IF EXISTS ( SELECT 1 FROM SYS.PROCEDURES WHERE NAME = 'P_EST_PROD_CPL_ENTRADAS' )
BEGIN 
	DROP PROCEDURE [P_EST_PROD_CPL_ENTRADAS]
END 

GO 
--EXEC P_EST_PROD_CPL_ENTRADAS  1,'1','','',0,0,0,'2015-03-04','2023-03-04',1

--EXEC [P_EST_PROD_CPL_ENTRADAS] 1, 1, 1, 1, 0, 1, 1, '2020-01-01', '2023-09-01'

CREATE PROCEDURE [P_EST_PROD_CPL_ENTRADAS](@CD_EMP              TINYINT,
                                        @CD_FILIAL           VARCHAR(8000),
                                        @CD_FORN             VARCHAR(8000),
										@CD_MOV	  			 VARCHAR (8000),
										@CANCEL			     TINYINT,
										@GRP			     TINYINT,
										@TP_DATA			 TINYINT,
                                        @DT_INI              DATE,
                                        @DT_FIM              DATE,
										@CD_USU				 INT=0,
										@VINCULO_SAI_NF_ENT	 INT=0)
AS
     /*********************************************************************************************************************************/
     SET NOCOUNT ON;
     /*********************************************************************************************************************************/
  BEGIN

	DECLARE @EXIBIR_LOTE INT

	SET @EXIBIR_LOTE = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP = @CD_EMP AND CD_CHAVE = 'APRESENTAR_COLUNA_NRLOTE_RELATORIO_ENTRADA_COMPRAS'),0);

	PRINT 'P_EST_PROD_CPL_ENTRADAS - CREATE 1 '+CONVERT(VARCHAR, GETDATE(), 108);
     CREATE TABLE #TmpResult
	([DT_ENT]                [Datetime] NULL,
	[STS_NF]                 [VARCHAR](9) NOT NULL,
	[SERIE]                  [VARCHAR](50) NOT NULL,
	[CD_ORIG]                [INT] NULL,
	[DT_EMI_NF]              [DATETIME] NULL,
	[NR_NF]                  [INT] NOT NULL,
	[CD_FILIAL]              [INT] NOT NULL,
	[CD_PROD]                [INT] NOT NULL,
	[DS_PROD]                [VARCHAR](150) NULL,
	[CD_BARRA]               [VARCHAR](150) NULL,
	[QT_IT]                  [MONEY] NOT NULL,
	[QT_IT_LOTE]             [MONEY] NOT NULL,
	[VLR_IT_TOTAL_BRUTO]     [MONEY] NULL,
	[VLR_IT]                 [FLOAT] NOT NULL,
	[VLR_DESC]               [MONEY] NOT NULL,
	[VLR_TOT_IT]             [FLOAT] NULL,
	[VLR_CUSTO_MD]           [MONEY] NULL,
	[VLR_BASE_ICMS]          [MONEY] NOT NULL,
	[VLR_ICMS_IT]            [MONEY] NOT NULL,
	[VLR_BASE_SUBS]          [MONEY] NOT NULL,
	[VLR_ICMS_SUBS]          [MONEY] NOT NULL,
	[VLR_ICMS_REAL]          [MONEY] NULL,
	[VLR_IPI]                [MONEY] NOT NULL,
	[CD_TRIB_FC]             [VARCHAR](50) NOT NULL,
	[CFOP]                   [VARCHAR](5) NULL,
    [DS_MOV_OP]              [VARCHAR](150) NOT NULL,
    [DS_SIGLA]               [VARCHAR](50) NOT NULL,
    [VLR_PRC_CUSTO]          [MONEY] NULL,
    [VLR_PMC]                [MONEY] NOT NULL,
    [VLR_OUTRAS_DESPESAS]    [FLOAT] NULL,
    [VLR_FRETE]              [FLOAT] NULL,
    [VLR_COMPRA]             [FLOAT] NULL,
    [NM_FABRIC]              [VARCHAR](60) NOT NULL,
    [DS_ARV_MERC_CATEG]      [VARCHAR](50) NOT NULL,
    [DS_ARV_MERC_DEPTO]      [VARCHAR](50) NOT NULL,
    [DS_ARV_MERC_AREA_ATEND] [VARCHAR](50) NOT NULL,
    [DS_ARV_MERC_SEG]        [VARCHAR](50) NOT NULL,
    [DS_ARV_MERC_LINHA]      [VARCHAR](50) NOT NULL,
    [DS_ARV_MERC_CONSUMO]    [VARCHAR](50) NOT NULL,
    [DS_ARV_MERC_MIX]        [VARCHAR](50) NOT NULL,
    [DS_ARV_MERC_PAPEL]      [VARCHAR](50) NOT NULL,
    [DS_ARV_MERC_FAMILIA]    [VARCHAR](100) NOT NULL,
    [DS_ARV_MERC_MTZ_BCG]    [VARCHAR](50) NOT NULL,
    [NM_ORIG_FANT]           [VARCHAR](250) NOT NULL,
    [TIPO_ENTRADA]           [VARCHAR](50) NOT NULL,
    [TIPO_FORNECEDOR]        [VARCHAR](100) NOT NULL,
    [ATU_EST]                [VARCHAR](23) NOT NULL,
    [NR_DP_PAG]              [INT] NOT NULL,
    [CONTASPAGAR]            [VARCHAR](3) NOT NULL,
    [EXPORT_NF_ESCRITA]      [VARCHAR](3) NOT NULL,
    [LISTA_PROD]             [VARCHAR](20) NULL,
    [PIS_COFINS]             [VARCHAR](3) NULL,
    [NR_NCM]                 [VARCHAR](50) NOT NULL,
    [PERC_IVA]               [MONEY] NOT NULL,
    [ALIQ_ICMS]              [MONEY] NOT NULL,
    [CNPJ]                   [VARCHAR](50) NOT NULL,
    [UF_EMISSOR]             [VARCHAR](2) NOT NULL,
    [UF]                     [VARCHAR](2) NOT NULL,
    [VLR_ICMS_RET]           [MONEY] NOT NULL,
    [VLR_CRED_BASE_SN]       [MONEY] NOT NULL,
    [VLR_CRED_ICMS_SN]       [MONEY] NOT NULL,
	[PERC_DESC_FINAN]        [MONEY] NOT NULL,
	[VLR_DESC_FINAN_PROD]    [MONEY] NOT NULL,
	[VLR_ISENTO]             [MONEY] NULL,
	[VLR_OUTROS]             [MONEY] NULL,
	[NR_AUTORIZADOR]         [VARCHAR](150) NULL,
	[MODELO]                 [VARCHAR](100) NOT NULL,
	[PERC_ALIQ_PIS]          [MONEY] NOT NULL,
	[PERC_ALIQ_COFINS]       [MONEY] NOT NULL,
	[VLR_BASE_PIS]           [MONEY] NOT NULL,
	[VLR_BASE_COFINS]        [MONEY] NOT NULL,
	[VLR_PIS]                [MONEY] NOT NULL,
	[VLR_COFINS]             [MONEY] NOT NULL,
	[PERC_REDU_BASE_SUBS_IT] [MONEY] NOT NULL,
	[PERC_REDU_BASE_ICMS_IT] [MONEY] NOT NULL,
	[CST_PIS]                [INT] NOT NULL,
	[ORIGEM_PRODUTO]         [INT] NOT NULL,
	[VLR_ICMS_SUBS_DARE]     [MONEY] NOT NULL,
	[VLR_FABRICA]            [MONEY] NULL,
	[VLR_SHELIN]             [MONEY] NOT NULL,
	[VLR_ICMS_DESONERADO]    [MONEY] NOT NULL,
	[DS_MC]                  [VARCHAR](50) NULL,
	[NR_CEST]                [VARCHAR](20) NOT NULL,
	[OBS1]				     [VARCHAR](50),
	[OBS2]				     [VARCHAR](50),
	[OBS3]				     [VARCHAR](50),
	[OBS4]				     [VARCHAR](50),
	[OBS5]				     [VARCHAR](50),
	[OBS6]				     [VARCHAR](50),
	[OBS7]				     [VARCHAR](50),
	[VLR_BASE_FECOP_ST_IT]   [MONEY] NOT NULL,
	[PERC_FECOP_ST]          [MONEY] NOT NULL,
	[VLR_FECOP_ST_IT]        [MONEY] NOT NULL,
	[VLR_BASE_FECOP_RET_IT]  [MONEY] NOT NULL,
	[PERC_FECOP_RET]         [MONEY] NOT NULL,
	[VLR_FECOP_RET_IT]       [MONEY] NOT NULL,
	[OBS]				     [VARCHAR](200),
	[VLR_FECOP]	             [MONEY] NOT NULL,
	[VLR_PMC_DAR_IT]         [MONEY] NOT NULL,
	[VLR_PMPF_DAR_IT]	     [MONEY] NOT NULL,
    [TP_SUBS_DAR_IT]	     [VARCHAR](20) NOT NULL,
	[NR_LOTE]				 [VARCHAR](100) NOT NULL,
	[CD_EMP]      		     [INT] NOT NULL,
	[CD_NF_ENT]    		     [INT] NOT NULL,
	[CD_BENEF]				 [VARCHAR](20) NOT NULL,
	[MOTIVO_DESONERADO_ICMS] [VARCHAR](500) NOT NULL,
	[VLR_ICMS_SUBSTITUTO] 	 [MONEY]
);
   END
	CREATE TABLE #TMPFILIAL (cd_emp int, cd_filial INT);
	IF @CD_FILIAL =''
	BEGIN
		PRINT 'INSERT 2 '+CONVERT(VARCHAR, GETDATE(), 108);
		INSERT INTO #TmpFilial
		SELECT CD_EMP, CD_FILIAL
		FROM PRC_FILIAL
	end
	ELSE
	begin
		PRINT 'INSERT 3 '+CONVERT(VARCHAR, GETDATE(), 108);
		INSERT INTO #TMPFILIAL
		SELECT CD_EMP,CD_FILIAL
		FROM PRC_FILIAL
		WHERE 
			CD_EMP = @CD_EMP
			AND CD_FILIAL IN(SELECT ID FROM UFD_PRM_IN_STRING(@cd_filial));
	END
/*********************************************************************************************************************************/
CREATE TABLE #RsProduto(CD_EMP INT, CD_PROD INT, VLR_FABRICA MONEY, NR_CEST VARCHAR(100),FLAG_PERMITE_RESSARCIMENTO_ICMS INT)
CREATE TABLE #RsProd (CD_EMP INT, CD_PROD INT);
IF EXISTS (SELECT TOP 1 * FROM GLB_ARV_MERC_FILTROS WHERE CD_USU = @CD_USU )
    BEGIN
        INSERT INTO #RsProduto
               SELECT
                      GLB_ARV_MERC_FILTROS.CD_EMP
                    , GLB_ARV_MERC_FILTROS.CD_PROD
                    , P.VLR_FABRICA
                    , P.NR_CEST
                    , ISNULL(P.FLAG_PERMITE_RESSARCIMENTO_ICMS, 0)
               FROM
                    GLB_ARV_MERC_FILTROS
                    INNER JOIN EST_PROD P ON GLB_ARV_MERC_FILTROS.CD_EMP = P.CD_EMP
                                             AND GLB_ARV_MERC_FILTROS.CD_PROD = P.CD_PROD
               WHERE GLB_ARV_MERC_FILTROS.CD_USU = @CD_USU;
    END;
    ELSE
    BEGIN
        IF @TP_DATA = 0
            BEGIN
                INSERT INTO #RsProd 
                       SELECT DISTINCT
                              O.CD_EMP
                            , O.CD_PROD 
                       FROM
                            EST_NF_ENT_IT O 
                            INNER JOIN #TMPFILIAL f ON O.CD_EMP = f.CD_EMP
                                                       AND O.CD_FILIAL = f.CD_FILIAL
                       WHERE O.CD_EMP = @CD_EMP
                             AND O.DT_ENT BETWEEN @DT_INI AND @DT_FIM;
            END;
            ELSE
            BEGIN
                INSERT INTO #RsProd 
                       SELECT DISTINCT
                              I.CD_EMP
                            , I.CD_PROD 
                       FROM
                            EST_NF_ENT_IT I
                            INNER JOIN EST_NF_ENT     ON I.CD_EMP		= EST_NF_ENT.CD_EMP
                                                     AND I.CD_FILIAL	= EST_NF_ENT.CD_FILIAL
                                                     AND I.CD_NF		= EST_NF_ENT.CD_NF
                                                     AND I.DT_ENT		= EST_NF_ENT.DT_ENT
                            INNER JOIN #TMPFILIAL f ON I.CD_EMP = f.CD_EMP
                                                       AND I.CD_FILIAL = f.CD_FILIAL
                       WHERE EST_NF_ENT.CD_EMP = @CD_EMP
                             AND EST_NF_ENT.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM;
            END;
			 INSERT INTO #RsProduto
                SELECT DISTINCT
                        p.CD_EMP
                    , p.CD_PROD
                    , p.VLR_FABRICA
                    , p.NR_CEST
                    , p.FLAG_PERMITE_RESSARCIMENTO_ICMS
                FROM
                    EST_PROD p
                    INNER JOIN #RsProd A ON p.CD_EMP = A.CD_EMP
                                                AND p.CD_PROD = A.CD_PROD
				WHERE p.CD_EMP = @CD_EMP
    END;
	CREATE NONCLUSTERED INDEX iX_#RsProduto ON [dbo].[#RsProduto] ([CD_EMP],[FLAG_PERMITE_RESSARCIMENTO_ICMS]) INCLUDE ([CD_PROD]);
/*********************************************************************************************************************************/
/*********************************************************************************************************************************/
    CREATE TABLE #TMPMOV (CD_MOV_OP INT);
	IF @CD_MOV =''
	BEGIN
		PRINT 'INSERT 4 '+CONVERT(VARCHAR, GETDATE(), 108);
		INSERT INTO #TMPMOV 
		SELECT CD_MOV_OP 
		FROM GLB_MOV_OP
	end
	ELSE
	begin
		PRINT 'INSERT 5 '+CONVERT(VARCHAR, GETDATE(), 108);
		INSERT INTO #TMPMOV 
		SELECT CD_MOV_OP 
		FROM GLB_MOV_OP 
		WHERE 
			CD_MOV_OP IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_MOV))
	END
/*********************************************************************************************************************************/
	CREATE TABLE #TMPFORN (CD_FORN INT);
	IF @CD_FORN =''
	begin
		PRINT 'INSERT 8 '+CONVERT(VARCHAR, GETDATE(), 108);
		INSERT INTO #TMPFORN
		SELECT -1
	end
	ELSE
	begin
		PRINT 'INSERT 9 '+CONVERT(VARCHAR, GETDATE(), 108);
		INSERT INTO #TmpForn
		SELECT CD_FORN
		FROM PG_FORN
		WHERE CD_EMP = @CD_EMP
		AND CD_FORN IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FORN));
	end
/*********************************************************************************************************************************/
	   CREATE TABLE #tmpresult2 (CD_EMP INT,CD_FILIAL INT ,CD_NF INT,CD_PROD INT,VLR_ICMS_REC FLOAT)
/*********************************************************************************************************************************/
	   IF  @TP_DATA =0 
	   BEGIN
			PRINT 'INSERT 11 '+CONVERT(VARCHAR, GETDATE(), 108);
		  INSERT INTO #TMPRESULT2 
		  SELECT 
			 I.CD_EMP,
			 I.CD_FILIAL,
			 I.CD_NF,
			 I.CD_PROD,
			 SUM((S.QT_IT * S.VLR_BASE_ICMS_ST) * .17) VLR_ICMS_REC
		  FROM 
			 EST_NF_ENT_IT I 
			 INNER JOIN EST_NF_ENT_IT_EST_PROD_CPL_TRIB_ST_CRED C ON 
			 I.CD_EMP = C.CD_EMP
			 AND I.CD_FILIAL = C.CD_FILIAL
			 AND I.CD_PROD = C.CD_PROD
			 AND I.CD_NF = C.CD_NF
			 inner join #TmpFilial fl on 
			 I.CD_FILIAL = fl.CD_FILIAL 
			 INNER JOIN #RsProduto P ON 
			 C.CD_EMP = P.CD_EMP
			 AND C.CD_PROD = P.CD_PROD
			 INNER JOIN EST_PROD_CPL_TRIB_ST_CRED S ON C.CD_CTR = S.CD_CTR
		  WHERE 
			 p.FLAG_PERMITE_RESSARCIMENTO_ICMS = 1
			 AND I.CD_EMP =@CD_EMP 		   
			 AND I.DT_ENT  BETWEEN @DT_INI AND @DT_FIM
		  GROUP BY 
			 I.CD_EMP,
			 I.CD_FILIAL,
			 I.CD_NF,
			 I.CD_PROD;
	   END
		ELSE
		BEGIN
			PRINT 'INSERT 12 '+CONVERT(VARCHAR, GETDATE(), 108);
			INSERT INTO #TMPRESULT2 
			SELECT 
				I.CD_EMP,
				I.CD_FILIAL,
				I.CD_NF,
				I.CD_PROD,
				SUM((S.QT_IT * S.VLR_BASE_ICMS_ST) * .17) VLR_ICMS_REC
			FROM 
				EST_NF_ENT_IT I
				INNER JOIN EST_NF_ENT E ON 
				I.CD_EMP	   = E.CD_EMP AND 
				I.CD_FILIAL = E.CD_FILIAL AND 
				I.DT_ENT	   = E.DT_ENT AND 
				I.CD_NF	   = E.CD_NF
				INNER JOIN EST_NF_ENT_IT_EST_PROD_CPL_TRIB_ST_CRED C ON 
				I.CD_EMP = C.CD_EMP
				AND I.CD_FILIAL = C.CD_FILIAL
				AND I.CD_PROD = C.CD_PROD
				AND I.CD_NF = C.CD_NF
				inner join #TmpFilial fl on 
				E.CD_FILIAL = fl.CD_FILIAL 
				INNER JOIN #RsProduto P ON 
				C.CD_EMP = P.CD_EMP
				AND C.CD_PROD = P.CD_PROD
				INNER JOIN EST_PROD_CPL_TRIB_ST_CRED S ON 
				C.CD_CTR = S.CD_CTR
			WHERE 
				p.FLAG_PERMITE_RESSARCIMENTO_ICMS = 1
				AND I.CD_EMP =@CD_EMP  
				AND   E.DT_EMI_NF  BETWEEN @DT_INI AND @DT_FIM
				GROUP BY 
				I.CD_EMP,
				I.CD_FILIAL,
				I.CD_NF,
				I.CD_PROD;
		END
/*********************************************************************************************************************************/
CREATE TABLE #EST_PROD_ARV_MERC (
		CD_EMP TINYINT,
		CD_PROD INT,
		DS_PROD			 VARCHAR (200),
		CD_ARV_MERC_LINHA		INT,
		CD_ARV_MERC_MTZ_BCG	    INT, 
		NM_FABRIC			    VARCHAR(200),
		DS_ARV_MERC_CATEG		    VARCHAR (200),
		DS_ARV_MERC_DEPTO		    VARCHAR (200),
		DS_ARV_MERC_AREA_ATEND	    VARCHAR (200),
		DS_ARV_MERC_SEG		    VARCHAR (200),
		DS_ARV_MERC_LINHA		    VARCHAR (200),
		DS_ARV_MERC_CONSUMO	    VARCHAR (200),
		DS_ARV_MERC_MIX		    VARCHAR (200),
		DS_ARV_MERC_PAPEL		    VARCHAR (200),
		DS_ARV_MERC_FAMILIA	    VARCHAR (200),
		DS_ARV_MERC_MTZ_BCG	    VARCHAR (200),
		DS_MC				    VARCHAR (50),
		CD_FABRIC			    INT  ,
		VLR_FABRICA			    MONEY,
		NR_CEST				    varchar(20));
	PRINT 'INSERT 13 '+CONVERT(VARCHAR, GETDATE(), 108);
    INSERT INTO #EST_PROD_ARV_MERC 
    SELECT 
	   A.CD_EMP,
	   A.CD_PROD,
	   A.DS_PROD,
	   A.CD_ARV_MERC_LINHA,
	   A.CD_ARV_MERC_MTZ_BCG , 
	   A.NM_FABRIC,
       A.DS_ARV_MERC_CATEG,
       A.DS_ARV_MERC_DEPTO,
       A.DS_ARV_MERC_AREA_ATEND,
       A.DS_ARV_MERC_SEG,
       A.DS_ARV_MERC_LINHA,
       A.DS_ARV_MERC_CONSUMO,
       A.DS_ARV_MERC_MIX,
       A.DS_ARV_MERC_PAPEL,
       A.DS_ARV_MERC_FAMILIA,
       A.DS_ARV_MERC_MTZ_BCG ,
	   A.DS_MC ,
	   A.CD_FABRIC,
	   P.VLR_FABRICA,
	   P.NR_CEST
    FROM 
	   V_EST_PROD_ARV_MERCADOLOGICA  A
	   INNER JOIN #RsProduto P  ON 
	   A.CD_PROD = P.CD_PROD AND
	   A.CD_EMP  = P.CD_EMP
create clustered index #_ix_est_prod_arv_merc on #est_prod_arv_merc (cd_emp,cd_prod); 
CREATE TABLE #RsNotaFiscalDuplicata(CD_EMP INT,
									CD_FILIAL INT,
									CD_NF INT,
									NR_DP INT,
									ANO INT)
IF @TP_DATA =0 
BEGIN
	PRINT 'INSERT 14 '+CONVERT(VARCHAR, GETDATE(), 108);
INSERT INTO #RsNotaFiscalDuplicata
SELECT
	DISTINCT EST_NF_ENT.CD_EMP,
	EST_NF_ENT.CD_FILIAL,
	EST_NF_ENT.CD_NF,
	PG_CRED_DUP_NR_CTR.NR_DP,
	PG_CRED_DUP_NR_CTR.ANO
FROM
	EST_NF_ENT INNER JOIN PG_CRED_EST_NF_ENT ON
	EST_NF_ENT.CD_EMP = PG_CRED_EST_NF_ENT.CD_EMP AND
	EST_NF_ENT.CD_FILIAL = PG_CRED_EST_NF_ENT.CD_FILIAL AND
	EST_NF_ENT.CD_NF = PG_CRED_EST_NF_ENT.CD_NF 
	INNER JOIN PG_CRED_DUP_NR_CTR ON
	PG_CRED_EST_NF_ENT.CD_EMP = PG_CRED_DUP_NR_CTR.CD_EMP AND
	PG_CRED_EST_NF_ENT.CD_FILIAL = PG_CRED_DUP_NR_CTR.CD_FILIAL AND
	PG_CRED_EST_NF_ENT.NR_DP = PG_CRED_DUP_NR_CTR.NR_DP AND
	PG_CRED_EST_NF_ENT.ANO = PG_CRED_DUP_NR_CTR.ANO
	inner join #TmpFilial fl on 
	EST_NF_ENT.CD_EMP= fl.CD_EMP AND
	EST_NF_ENT.CD_FILIAL = fl.CD_FILIAL  
WHERE
	EST_NF_ENT.CD_EMP=@CD_EMP
	AND EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM
END
ELSE
BEGIN
	PRINT 'INSERT 15 '+CONVERT(VARCHAR, GETDATE(), 108);
INSERT INTO #RsNotaFiscalDuplicata
SELECT
	DISTINCT EST_NF_ENT.CD_EMP,
	EST_NF_ENT.CD_FILIAL,
	EST_NF_ENT.CD_NF,
	PG_CRED_DUP_NR_CTR.NR_DP,
	PG_CRED_DUP_NR_CTR.ANO
FROM
	EST_NF_ENT INNER JOIN PG_CRED_EST_NF_ENT ON
	EST_NF_ENT.CD_EMP = PG_CRED_EST_NF_ENT.CD_EMP AND
	EST_NF_ENT.CD_FILIAL = PG_CRED_EST_NF_ENT.CD_FILIAL AND
	EST_NF_ENT.CD_NF = PG_CRED_EST_NF_ENT.CD_NF 
	INNER JOIN PG_CRED_DUP_NR_CTR ON
	PG_CRED_EST_NF_ENT.CD_EMP = PG_CRED_DUP_NR_CTR.CD_EMP AND
	PG_CRED_EST_NF_ENT.CD_FILIAL = PG_CRED_DUP_NR_CTR.CD_FILIAL AND
	PG_CRED_EST_NF_ENT.NR_DP = PG_CRED_DUP_NR_CTR.NR_DP AND
	PG_CRED_EST_NF_ENT.ANO = PG_CRED_DUP_NR_CTR.ANO
	inner join #TmpFilial fl on 
	EST_NF_ENT.CD_EMP= fl.CD_EMP AND
	EST_NF_ENT.CD_FILIAL = fl.CD_FILIAL  
WHERE
	EST_NF_ENT.CD_EMP=@CD_EMP
	AND EST_NF_ENT.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM
END
/*********************************************************************************************************************************/
	IF @TP_DATA =0 
	BEGIN
		CREATE TABLE #RsNotaA  (CD_EMP INT,CD_FILIAL INT,CD_NF INT) 
		insert into #RsNotaA
		SELECT 
			e.cd_emp, e.cd_filial, e.cd_nf
		from 
			est_nf_ent e
		    LEFT OUTER JOIN EST_NF_ENT_CANCEL c ON 
						e.CD_EMP	= c.CD_EMP
					AND e.CD_FILIAL = c.CD_FILIAL
					AND e.CD_NF		= c.CD_NF 
			 INNER JOIN #TMPMOV ON 
			 e.CD_NT_MOV = #TMPMOV.CD_MOV_OP
			 inner join #TmpFilial fl on 
			 e.CD_FILIAL = fl.CD_FILIAL  
		WHERE 
			e.CD_EMP =@CD_EMP
			AND e.DT_ENT BETWEEN @DT_INI AND @DT_FIM
			AND c.CD_NF IS NULL  ;
		PRINT 'INSERT 16 '+CONVERT(VARCHAR, GETDATE(), 108);
		
		IF @EXIBIR_LOTE = 1
		BEGIN
			INSERT INTO #TMPRESULT
			SELECT 
				MAX(V_EST_NF_ENT.DT_ENT) AS DT_ENT,
				MAX(CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN 'NORMAL'
				ELSE 'CANCELADA' END) STS_NF,
				MAX(V_EST_NF_ENT.SERIE) SERIE,
				MAX(V_EST_NF_ENT.CD_ORIG) CD_ORIG,
				MAX(V_EST_NF_ENT.DT_EMI_NF) AS DT_EMI_NF ,
				MAX(V_EST_NF_ENT.NR_NF) NR_NF,
				MAX(V_EST_NF_ENT.CD_FILIAL) CD_FILIAL,
				V_EST_NF_ENT.CD_PROD,
				MAX(MERC.DS_PROD) AS DS_PROD,
				COALESCE(
				(SELECT TOP 1 MAX(CD_BARRA) FROM EST_PROD_CD_BARRA WHERE CD_EMP = MAX(MERC.CD_EMP) AND CD_PROD = MAX(MERC.CD_PROD) AND COALESCE(EAN_CAIXA_FECHADA,0) = 0 AND COALESCE(NAO_ENVIA_WMS,0) = 0 AND COALESCE(FLAG_PRE_VENCIDOS,0) = 0 
				ORDER BY MAX(DT_CAD) DESC),'') AS CD_BARRA,
				--   V_EST_NF_ENT.QT_IT, ---- TIRAR ESSE
				MAX(COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD, V_EST_NF_ENT.QT_IT, 0)) AS QT_IT,
				--   V_EST_NF_ENT.QT_IT_LOTE, ---- TIRAR ESSE
				MAX(COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,0)) AS QT_IT_LOTE,
				--   V_EST_NF_ENT.VLR_IT * V_EST_NF_ENT.QT_IT AS VLR_IT_TOTAL_BRUTO,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IT) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT))),2) AS VLR_IT_TOTAL_BRUTO,
				--   CONVERT(FLOAT,V_EST_NF_ENT.VLR_TOT_IT)/CONVERT(FLOAT,V_EST_NF_ENT.QT_IT) AS VLR_IT,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT))),13) AS VLR_IT,
				--   V_EST_NF_ENT.VLR_DESC_IT AS VLR_DESC,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_DESC_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_DESC,
				--   V_EST_NF_ENT.QT_IT * (V_EST_NF_ENT.VLR_IT - (V_EST_NF_ENT.VLR_DESC_IT / CONVERT(FLOAT,V_EST_NF_ENT.QT_IT))) AS VLR_TOT_IT,
				ROUND(AVG((CONVERT(DECIMAL(38,10), COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)) * (CONVERT(DECIMAL(38,10),V_EST_NF_ENT.VLR_IT) - (CONVERT(DECIMAL(38,10),V_EST_NF_ENT.VLR_DESC_IT) / CONVERT(FLOAT,CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)))))),2) AS VLR_TOT_IT,
				--   ROUND((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_CUSTO_MD), 2) AS VLR_CUSTO_MD,
				ROUND(AVG(CONVERT(DECIMAL(38,10), COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)) 
				* (CONVERT(DECIMAL(38,10),V_EST_NF_ENT.VLR_CUSTO_MD))), 2) AS VLR_CUSTO_MD,	
				--   V_EST_NF_ENT.VLR_BASE_ICMS_IT AS VLR_BASE_ICMS,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_ICMS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) 
				* COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_BASE_ICMS,
				--   V_EST_NF_ENT.VLR_ICMS_IT,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) 
				* COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_ICMS_IT,
				--   V_EST_NF_ENT.VLR_BASE_SUBS_IT AS VLR_BASE_SUBS,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) 
				* COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_BASE_SUBS,
				--   V_EST_NF_ENT.VLR_ICMS_SUBS_IT AS VLR_ICMS_SUBS,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) 
				* COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_ICMS_SUBS,
				CASE
				WHEN COALESCE(MAX(SC.CD_PROD),0) = 0
					THEN 0
					ELSE 
						--SC.VLR_ICMS_REC
						ROUND(AVG((CONVERT(DECIMAL(38,10), SC.VLR_ICMS_REC) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) 
				END VLR_ICMS_REAL,
				--   V_EST_NF_ENT.VLR_IPI_IT AS VLR_IPI,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_IPI,
				MAX(V_EST_NF_ENT.CD_TRIB_FC) AS CD_TRIB_FC,
				MAX(LEFT(V_EST_NF_ENT.CFOP, 5)) AS CFOP,
				MAX(V_EST_NF_ENT.DS_MOV_OP_USUAL) AS DS_MOV_OP,
				MAX(CASE WHEN C.CD_SIGLA = 4 THEN 'D' 
					WHEN C.CD_SIGLA = 3 THEN 'C' 
					WHEN C.CD_SIGLA = 2 THEN 'B' 
					WHEN C.CD_SIGLA = 1 THEN 'A' 
					WHEN C.CD_SIGLA = 5 THEN 'AA' 
					ELSE 
				'D' 
				END) DS_SIGLA,
				--   (V_EST_NF_ENT.VLR_PRC_CUSTO * V_EST_NF_ENT.QT_IT) AS VLR_PRC_CUSTO,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_PRC_CUSTO) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT))),2) AS VLR_PRC_CUSTO,
				CASE WHEN ISNULL(MAX(V_EST_NF_ENT.VLR_PMC_DAR_IT), 0 ) > 0 THEN 
					ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_PMC_DAR_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) 
					ELSE 
						--ISNULL( V_EST_NF_ENT.VLR_PROD_PMC, 0 )
					ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_PROD_PMC) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) 
					* COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2)
				END AS VLR_PMC,
				CASE
				WHEN MAX(COALESCE(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0)) = 0
					THEN 
						--VLR_OUTROS_CABE_RATEIO
					ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_OUTROS_CABE_RATEIO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) 
					* COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) 
					ELSE 
						--V_EST_NF_ENT.VLR_OUTRAS_DESPESAS
					ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_OUTRAS_DESPESAS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) 
				END AS VLR_OUTRAS_DESPESAS,
				--VLR_FRETE_CABE_RATEIO AS VLR_FRETE,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_FRETE,
				CASE WHEN MAX(V_EST_NF_ENT.VLR_OUTROS) = 0 THEN 
					CASE 
						WHEN MAX(V_EST_NF_ENT.VLR_FRETE) = 0 THEN 
							(((ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IT) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT))),2)) - ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_DESC_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2))
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							)
							+
							CASE WHEN MAX(FLAG_ICMS_SUBST_PAGO_ANTERIOR) = 1 THEN 
								0
							ELSE 
								ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_RET) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							END 
								+ ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_OUTRAS_DESPESAS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) 
													- CASE WHEN MAX(V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO) = 1  THEN 
														ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_DESONERADO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0)					
														ELSE 
															0 
													END 			
							ELSE 
								(((ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IT) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT))),2)) - ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_DESC_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2))
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								)
								+
								(
									ROUND((CONVERT( FLOAT, MAX(V_EST_NF_ENT.VLR_FRETE)) / CONVERT(FLOAT, MAX(V_EST_NF_ENT.VLR_NF) - MAX(V_EST_NF_ENT.VLR_FRETE))), 9)
									* (ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
									+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
									+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
									+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
									)				
								) +
								CASE WHEN MAX(FLAG_ICMS_SUBST_PAGO_ANTERIOR) = 1 THEN 
									0
								ELSE 
									ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_RET) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								END + ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_OUTRAS_DESPESAS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) 
										- CASE WHEN MAX(V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO) = 1  THEN 
											ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_DESONERADO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
										ELSE 
										0 
										END  - CASE WHEN MAX(V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO) = 1  THEN 
												ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_DESONERADO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
												ELSE  0 
												END
						END
					ELSE 
						CASE WHEN CONVERT(FLOAT, MAX(V_EST_NF_ENT.VLR_NF) - MAX(V_EST_NF_ENT.VLR_OUTROS)) > 0 THEN 
							CASE WHEN MAX(V_EST_NF_ENT.VLR_FRETE) = 0 THEN 
								(((ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IT) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT))),2)) - ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_DESC_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2))
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ (
								ROUND((CONVERT(FLOAT, MAX(V_EST_NF_ENT.VLR_OUTROS)) / CONVERT(FLOAT, MAX(V_EST_NF_ENT.VLR_NF) - MAX(V_EST_NF_ENT.VLR_OUTROS))), 9) 
								*(
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)				  
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)					
								)
								))				
								+
								CASE WHEN MAX(FLAG_ICMS_SUBST_PAGO_ANTERIOR) = 1 THEN 
									0
								ELSE 
									ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_RET) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2),0)
								END 
								- CASE WHEN MAX(V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO) = 1  THEN 
									ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_DESONERADO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2),0)
									ELSE 
									0 
									END
							ELSE 
								(((ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IT) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT))),2)) - ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_DESC_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2))
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ (
								ROUND((CONVERT(FLOAT, MAX(V_EST_NF_ENT.VLR_OUTROS)) / CONVERT(FLOAT, MAX(V_EST_NF_ENT.VLR_NF) - MAX(V_EST_NF_ENT.VLR_OUTROS))), 9) 
								*(
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)					
								)
								)
								) + 
								CASE WHEN MAX(FLAG_ICMS_SUBST_PAGO_ANTERIOR) = 1 THEN  0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
								END - CASE WHEN MAX(V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO) = 1  THEN 
									ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_DESONERADO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2),0)
											ELSE 0 
										END
								END
							ELSE 0
						END
				END AS VLR_COMPRA,
				MAX(MERC.NM_FABRIC) AS NM_FABRIC,
				MAX(MERC.DS_ARV_MERC_CATEG) AS DS_ARV_MERC_CATEG,
				MAX(MERC.DS_ARV_MERC_DEPTO) AS DS_ARV_MERC_DEPTO,
				MAX(MERC.DS_ARV_MERC_AREA_ATEND) AS DS_ARV_MERC_AREA_ATEND,
				MAX(MERC.DS_ARV_MERC_SEG) AS DS_ARV_MERC_SEG,
				MAX(MERC.DS_ARV_MERC_LINHA) AS DS_ARV_MERC_LINHA,
				MAX(MERC.DS_ARV_MERC_CONSUMO) AS DS_ARV_MERC_CONSUMO,
				MAX(MERC.DS_ARV_MERC_MIX) AS DS_ARV_MERC_MIX,
				MAX(MERC.DS_ARV_MERC_PAPEL) AS DS_ARV_MERC_PAPEL,
				MAX(MERC.DS_ARV_MERC_FAMILIA) AS DS_ARV_MERC_FAMILIA,
				MAX(MERC.DS_ARV_MERC_MTZ_BCG) AS DS_ARV_MERC_MTZ_BCG,
				MAX(V_EST_NF_ENT.NM_ORIG_FANT) AS NM_ORIG_FANT,
				CASE
					WHEN MAX(V_EST_NF_ENT.TP_MOV) = 0
					THEN 'COMPRAS'
					ELSE 'OUTRAS ENTRADAS'
				END TIPO_ENTRADA,
				MAX(TIPO_FORNECEDOR) AS TIPO_FORNECEDOR,
				CASE
					WHEN MAX(V_EST_NF_ENT.ATU_EST) = 1
					THEN 'ACRESCENTOU ESTOQUE'
					ELSE 'NAO ACRESCENTOU ESTOQUE'
				END AS ATU_EST,
				ISNULL(MAX(CRED.NR_DP), 0) AS NR_DP_PAG,
				MAX(CASE
					WHEN CRED.CD_NF IS NULL
					THEN 'NAO'
					ELSE 'SIM'
				END) AS CONTASPAGAR,
				MAX(CASE
					WHEN V_EST_NF_ENT.EXPORT_NF_ESCRITA = 0
					THEN 'SIM'
					ELSE 'NAO'
				END) AS EXPORT_NF_ESCRITA,
				MAX(CASE
					WHEN V_EST_NF_ENT.LISTA_PROD = 0
					THEN '0 - POSITIVA'
					WHEN V_EST_NF_ENT.LISTA_PROD = 1
					THEN '1 - NEGATIVA'
					WHEN V_EST_NF_ENT.LISTA_PROD = 2
					THEN '2 - NEUTRA'
					WHEN V_EST_NF_ENT.LISTA_PROD = 3
					THEN '3 - NAO USA LISTA'
				END) AS LISTA_PROD,
				MAX(CASE
					WHEN V_EST_NF_ENT.PIS_COFINS = 0
					THEN 'NAO'
					WHEN V_EST_NF_ENT.PIS_COFINS = 1
					THEN 'SIM'
				END) AS PIS_COFINS,
				MAX(V_EST_NF_ENT.NR_NCM) AS NR_NCM,
				MAX(V_EST_NF_ENT.PERC_IVA) AS PERC_IVA,
				MAX(V_EST_NF_ENT.ALIQ_ICMS) AS ALIQ_ICMS,
				MAX(V_EST_NF_ENT.CGC_CPF) AS CNPJ,
				MAX(V_EST_NF_ENT.UF) AS UF_EMISSOR,
				MAX(V_EST_NF_ENT.UF_DESTINATARIO) AS  UF,
				--ROUND(V_EST_NF_ENT.VLR_ICMS_RET, 2) AS VLR_ICMS_RET,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_RET) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_ICMS_RET,
				--MAX(V_EST_NF_ENT.VLR_CRED_BASE_SN) AS VLR_CRED_BASE_SN,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_CRED_BASE_SN) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_CRED_BASE_SN,    
				--MAX(V_EST_NF_ENT.VLR_CRED_ICMS_SN) AS VLR_CRED_ICMS_SN,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_CRED_ICMS_SN) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_CRED_ICMS_SN,
				--MAX(V_EST_NF_ENT.PERC_DESC_FINAN) AS PERC_DESC_FINAN,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.PERC_DESC_FINAN) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS PERC_DESC_FINAN,
				--MAX(V_EST_NF_ENT.VLR_DESC_FINAN_PROD) AS VLR_DESC_FINAN_PROD,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_DESC_FINAN_PROD) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_DESC_FINAN_PROD,
				CASE WHEN MAX(V_EST_NF_ENT.ISENTO) = 1 THEN 
					--V_EST_NF_ENT.VLR_TOT_IT
					ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
					ELSE 0
				END AS VLR_ISENTO,
				CASE
					WHEN MAX(V_EST_NF_ENT.SUBS_TRIB_ANT) = 1 THEN 
						--V_EST_NF_ENT.VLR_TOT_IT
						ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
					ELSE CASE WHEN(MAX(ICMS) + MAX(SUBS_TRIB) + MAX(ICMS_RD)) > 1 THEN 
							--V_EST_NF_ENT.VLR_TOT_IT - V_EST_NF_ENT.VLR_BASE_ICMS_IT
							ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							-
							ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_ICMS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							ELSE 0
						END
				END + ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_OUTRAS_DESPESAS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) , 0) 
				AS VLR_OUTROS,
				MAX(ISNULL(V_EST_NF_ENT.NR_AUTORIZADOR,0)) + SPACE(1) AS NR_AUTORIZADOR,
				MAX(V_EST_NF_ENT.MODELO) AS MODELO,
				MAX(V_EST_NF_ENT.PERC_ALIQ_PIS) AS PERC_ALIQ_PIS,
				MAX(V_EST_NF_ENT.PERC_ALIQ_COFINS) AS PERC_ALIQ_COFINS,
				--   V_EST_NF_ENT.VLR_BASE_PIS,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_PIS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_BASE_PIS,
				--   V_EST_NF_ENT.VLR_BASE_COFINS,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_COFINS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_BASE_COFINS,
				--   V_EST_NF_ENT.VLR_PIS,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_PIS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_PIS,
				--   V_EST_NF_ENT.VLR_COFINS,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_COFINS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_COFINS,
				MAX(V_EST_NF_ENT.PERC_REDU_BASE_SUBS_IT) AS PERC_REDU_BASE_SUBS_IT ,
				MAX(V_EST_NF_ENT.PERC_REDU_BASE_ICMS_IT) AS PERC_REDU_BASE_ICMS_IT,
				MAX(V_EST_NF_ENT.CST_PIS) AS CST_PIS,
				MAX(V_EST_NF_ENT.ORIGEM_PRODUTO) AS ORIGEM_PRODUTO,
				--   V_EST_NF_ENT.VLR_ICMS_SUBS_DARE,
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_DARE) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_ICMS_SUBS_DARE,
				COALESCE(max(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD),max(V_EST_NF_ENT.QT_IT))
					* max(CASE WHEN ISNULL(MERC.VLR_FABRICA, 0) > 0 THEN 
					ISNULL(MERC.VLR_FABRICA, 0)
				  ELSE 
					ISNULL(V_EST_PROD_PRECO_TBL.VLR_FORN, 0)
				  END) AS VLR_FABRICA,	
				--ISNULL(MAX(V_EST_PROD_PRECO_TBL.VLR_FORN), 0) AS VLR_SHELIN,
				ROUND(AVG((CONVERT(DECIMAL(38,10), ISNULL(V_EST_PROD_PRECO_TBL.VLR_FORN,0)) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_SHELIN,
				--ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0) AS VLR_ICMS_DESONERADO,
				ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_DESONERADO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_ICMS_DESONERADO,
				MAX(MERC.DS_MC) AS DS_MC,
				ISNULL(MAX(MERC.NR_CEST), '') NR_CEST,
				LEFT(ISNULL(MAX(V_EST_NF_ENT.OBS1),''),50) AS OBS1,	
				CASE WHEN LEN(MAX(V_EST_NF_ENT.OBS1)) > 50 THEN LEFT(RIGHT(MAX(V_EST_NF_ENT.OBS1),LEN(MAX(V_EST_NF_ENT.OBS1)) - 50),50) ELSE '' END AS OBS2,
				CASE WHEN LEN(MAX(V_EST_NF_ENT.OBS1)) > 100 THEN RIGHT(MAX(V_EST_NF_ENT.OBS1),LEN(MAX(V_EST_NF_ENT.OBS1)) - 100) ELSE '' END AS OBS3,
				LEFT(ISNULL(MAX(V_EST_NF_ENT.OBS2),''),50) AS OBS4,
				CASE WHEN LEN(MAX(V_EST_NF_ENT.OBS2)) > 50 THEN LEFT(RIGHT(MAX(V_EST_NF_ENT.OBS2),LEN(MAX(V_EST_NF_ENT.OBS2)) - 50),50) ELSE '' END AS OBS5,
				LEFT(ISNULL(MAX(V_EST_NF_ENT.OBS4),''),50) AS OBS6,
				LEFT(ISNULL(MAX(V_EST_NF_ENT.OBS5),''),50) AS OBS7,
				--VLR_BASE_FECOP_ST_IT,
				ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_BASE_FECOP_ST_IT,
				MAX(V_EST_NF_ENT.PERC_FECOP_ST) AS PERC_FECOP_ST,
				ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_FECOP_ST_IT,
				ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_FECOP_RET_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_BASE_FECOP_RET_IT,
				MAX(V_EST_NF_ENT.PERC_FECOP_RET) AS PERC_FECOP_RET,
				--V_EST_NF_ENT.VLR_FECOP_RET_IT,
				ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_RET_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_FECOP_RET_IT,
				MAX(EST_PED_VD.OBS) AS OBS,
				MAX(V_EST_NF_ENT.VLR_FECOP) AS VLR_FECOP,
				--V_EST_NF_ENT.VLR_PMC_DAR_IT,
				ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_PMC_DAR_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_PMC_DAR_IT,
				--V_EST_NF_ENT.VLR_PMPF_DAR_IT,
				ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_PMPF_DAR_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_PMPF_DAR_IT,			 
				CASE
					WHEN MAX(V_EST_NF_ENT.TP_SUBS_DAR_IT) = 0
					THEN '0 - MVA'
					WHEN MAX(V_EST_NF_ENT.TP_SUBS_DAR_IT) = 1
					THEN '1 - PAUTA'
					WHEN MAX(V_EST_NF_ENT.TP_SUBS_DAR_IT) = 2
					THEN '2 - CARGA TRIB'
					WHEN MAX(V_EST_NF_ENT.TP_SUBS_DAR_IT) = 3
					THEN '3 - PREÇO PMC'
					WHEN MAX(V_EST_NF_ENT.TP_SUBS_DAR_IT) = 4
					THEN '4 - PREÇO PMPF'
					ELSE ''
				END AS TP_SUBS_DAR_IT,
				ISNULL(L.NR_LOTE,'') AS NR_LOTE
				,V_EST_NF_ENT.CD_EMP
				,V_EST_NF_ENT.CD_NF
				,ISNULL(V_EST_NF_ENT.CD_BENEF_IT,'') AS CD_BENEF
				,ISNULL(MOTIVO.DESCRICAO,'') AS MOTIVO_DESONERADO_ICMS
				,ISNULL(V_EST_NF_ENT.VLR_ICMS_SUBSTITUTO,0) AS VLR_ICMS_SUBSTITUTO
			FROM 		 
				V_EST_NF_ENT 
				INNER JOIN  #RsNotaA  B ON 
				V_EST_NF_ENT.CD_EMP	= B.CD_EMP AND
				V_EST_NF_ENT.CD_FILIAL = B.CD_FILIAL AND
				V_EST_NF_ENT.CD_NF		= B.CD_NF 
				LEFT JOIN EST_NF_ENT_PED_VD ON
				V_EST_NF_ENT.CD_EMP = EST_NF_ENT_PED_VD.CD_EMP AND
				V_EST_NF_ENT.CD_FILIAL = EST_NF_ENT_PED_VD.CD_FILIAL AND
				V_EST_NF_ENT.CD_NF = EST_NF_ENT_PED_VD.CD_NF
				LEFT JOIN EST_PED_VD ON
				EST_NF_ENT_PED_VD.CD_EMP = EST_PED_VD.CD_EMP AND
				EST_NF_ENT_PED_VD.CD_FILIAL = EST_PED_VD.CD_FILIAL AND
				EST_NF_ENT_PED_VD.CD_PED = EST_PED_VD.CD_PED
				INNER JOIN EST_PROD_CPL C ON 
				V_EST_NF_ENT.CD_EMP	= C.CD_EMP AND 
				V_EST_NF_ENT.CD_PROD	= C.CD_PROD AND 
				V_EST_NF_ENT.CD_FILIAL	= C.CD_FILIAL 
				INNER JOIN #EST_PROD_ARV_MERC MERC ON 
				C.CD_EMP = MERC.CD_EMP AND 
				C.CD_PROD = MERC.CD_PROD  
				LEFT OUTER JOIN V_EST_PROD_PRECO_TBL ON 
				V_EST_NF_ENT.CD_EMP = V_EST_PROD_PRECO_TBL.CD_EMP
				AND V_EST_NF_ENT.CD_FILIAL = V_EST_PROD_PRECO_TBL.CD_FILIAL
				AND V_EST_NF_ENT.CD_PROD = V_EST_PROD_PRECO_TBL.CD_PROD
				LEFT JOIN #TMPRESULT2 SC ON 
				V_EST_NF_ENT.CD_EMP = SC.CD_EMP
				AND V_EST_NF_ENT.CD_FILIAL = SC.CD_FILIAL
				AND V_EST_NF_ENT.CD_NF = SC.CD_NF
				AND V_EST_NF_ENT.CD_PROD = SC.CD_PROD
				LEFT OUTER JOIN #RsNotaFiscalDuplicata CRED ON 
				V_EST_NF_ENT.CD_EMP = CRED.CD_EMP AND
				V_EST_NF_ENT.CD_FILIAL = CRED.CD_FILIAL AND
				V_EST_NF_ENT.CD_NF = CRED.CD_NF 
				---ADD DAQUI PARA BAIXO PARA PEGAR O LOTE ----------
				INNER JOIN EST_NF_ENT_IT I ON
				V_EST_NF_ENT.CD_EMP=I.CD_EMP AND
				V_EST_NF_ENT.CD_FILIAL=I.CD_FILIAL AND
				V_EST_NF_ENT.CD_NF=I.CD_NF AND
				V_EST_NF_ENT.CD_PROD=I.CD_PROD
				LEFT OUTER JOIN EST_NF_ENT_IT_EST_PROD_CPL_LOTE ON
				I.CD_EMP=EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP AND
				I.CD_FILIAL=EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL AND
				I.CD_NF=EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_NF AND 
				I.CD_PROD=EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_PROD
				LEFT OUTER JOIN EST_PROD_CPL_LOTE L ON
				L.CD_EMP=V_EST_NF_ENT.CD_EMP AND
				L.CD_FILIAL=V_EST_NF_ENT.CD_FILIAL AND
				L.CD_PROD=I.CD_PROD AND 
				L.CD_LOTE=EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_LOTE
				OUTER APPLY (SELECT TOP 1 MOTIVO.DESCRICAO FROM TBL_ICMS_DESONERADO_MOTIVO MOTIVO WHERE V_EST_NF_ENT.ICMS_DESONERADO_MOTIVO = MOTIVO.CD_MOTIVO) MOTIVO
				-----------FIM PEGA LOTE ------------
			WHERE 
				V_EST_NF_ENT.CD_EMP =@CD_EMP
				AND V_EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM  
				AND V_EST_NF_ENT.CD_FORN_FILIAL = CASE  WHEN @GRP = 1  THEN 0
											WHEN @GRP = 0 THEN  V_EST_NF_ENT.CD_FORN_FILIAL
											END 
				AND V_EST_NF_ENT.STS_NF = CASE  WHEN @CANCEL = 0  THEN 0
										WHEN @CANCEL = 1 THEN  V_EST_NF_ENT.STS_NF
										END 
				and  case when @cd_forn = '' then	 - 1 
						else  V_EST_NF_ENT.CD_FORN end in (select CD_FORN from #TMPFORN)  						 
				AND V_EST_NF_ENT.QT_IT <> 0 
			GROUP BY V_EST_NF_ENT.CD_PROD ,L.NR_LOTE ,V_EST_NF_ENT.CD_EMP,V_EST_NF_ENT.CD_NF,V_EST_NF_ENT.CD_BENEF_IT
				, MOTIVO.DESCRICAO, V_EST_NF_ENT.VLR_ICMS_SUBSTITUTO
			ORDER BY V_EST_NF_ENT.CD_PROD;	
		END
		ELSE
		BEGIN
			INSERT INTO #TMPRESULT
  
			SELECT 
				V_EST_NF_ENT.DT_ENT,
				CASE WHEN V_EST_NF_ENT.STS_NF = 0 THEN 'NORMAL'
				ELSE 'CANCELADA' END STS_NF,
				V_EST_NF_ENT.SERIE,
				V_EST_NF_ENT.CD_ORIG,
				V_EST_NF_ENT.DT_EMI_NF,
				V_EST_NF_ENT.NR_NF,
				V_EST_NF_ENT.CD_FILIAL,
				V_EST_NF_ENT.CD_PROD,
				MERC.DS_PROD,
				COALESCE((SELECT TOP 1 CD_BARRA FROM EST_PROD_CD_BARRA WHERE CD_EMP = MERC.CD_EMP AND CD_PROD = MERC.CD_PROD AND COALESCE(EAN_CAIXA_FECHADA,0) = 0 AND COALESCE(NAO_ENVIA_WMS,0) = 0 AND COALESCE(FLAG_PRE_VENCIDOS,0) = 0 ORDER BY DT_CAD DESC),'') AS CD_BARRA,
				V_EST_NF_ENT.QT_IT,
				0 AS QT_IT_LOTE,
				(V_EST_NF_ENT.VLR_IT * V_EST_NF_ENT.QT_IT) AS VLR_IT_TOTAL_BRUTO,
				CONVERT(FLOAT,V_EST_NF_ENT.VLR_TOT_IT)/CONVERT(FLOAT,V_EST_NF_ENT.QT_IT) AS VLR_IT,
				V_EST_NF_ENT.VLR_DESC_IT AS VLR_DESC,         
				V_EST_NF_ENT.QT_IT * (V_EST_NF_ENT.VLR_IT - (V_EST_NF_ENT.VLR_DESC_IT / CONVERT(FLOAT,V_EST_NF_ENT.QT_IT))) as VLR_TOT_IT,
				ROUND((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_CUSTO_MD), 2) AS VLR_CUSTO_MD,
				V_EST_NF_ENT.VLR_BASE_ICMS_IT AS VLR_BASE_ICMS,
				V_EST_NF_ENT.VLR_ICMS_IT,
				V_EST_NF_ENT.VLR_BASE_SUBS_IT AS VLR_BASE_SUBS,
				V_EST_NF_ENT.VLR_ICMS_SUBS_IT AS VLR_ICMS_SUBS,
				CASE
				WHEN COALESCE(SC.CD_PROD,0) = 0
					THEN 0
					ELSE SC.VLR_ICMS_REC
				END VLR_ICMS_REAL,
				V_EST_NF_ENT.VLR_IPI_IT AS VLR_IPI,
				V_EST_NF_ENT.CD_TRIB_FC,
				LEFT(V_EST_NF_ENT.CFOP, 5) AS CFOP,
				V_EST_NF_ENT.DS_MOV_OP_USUAL AS DS_MOV_OP,
				CASE WHEN C.CD_SIGLA = 4 THEN 'D' 
					WHEN C.CD_SIGLA = 3 THEN 'C' 
					WHEN C.CD_SIGLA = 2 THEN 'B' 
					WHEN C.CD_SIGLA = 1 THEN 'A' 
					WHEN C.CD_SIGLA = 5 THEN 'AA' 
					ELSE 'D' END DS_SIGLA,
				(V_EST_NF_ENT.VLR_PRC_CUSTO * V_EST_NF_ENT.QT_IT) AS VLR_PRC_CUSTO,
				CASE WHEN ISNULL(V_EST_NF_ENT.VLR_PMC_DAR_IT, 0 )> 0 THEN V_EST_NF_ENT.VLR_PMC_DAR_IT
					 ELSE ISNULL( V_EST_NF_ENT.VLR_PROD_PMC, 0 )
				 END			AS VLR_PMC,
				CASE
				WHEN COALESCE(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0) = 0
					THEN VLR_OUTROS_CABE_RATEIO
					ELSE V_EST_NF_ENT.VLR_OUTRAS_DESPESAS
				END AS VLR_OUTRAS_DESPESAS,
				VLR_FRETE_CABE_RATEIO AS VLR_FRETE,
				CASE
					WHEN V_EST_NF_ENT.VLR_OUTROS = 0
					THEN CASE
							WHEN V_EST_NF_ENT.VLR_FRETE = 0 THEN 
								(((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT +  V_EST_NF_ENT.VLR_FECOP_ST_IT) + 
								CASE WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1 THEN 
									0
								ELSE 
									V_EST_NF_ENT.VLR_ICMS_RET
								END + ISNULL(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0) - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
																						 ELSE 0 
																					 END 
							
							ELSE 
								(((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT +  V_EST_NF_ENT.VLR_FECOP_ST_IT + (ROUND((CONVERT( FLOAT, V_EST_NF_ENT.VLR_FRETE) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_FRETE)), 9) * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT + V_EST_NF_ENT.VLR_FECOP_ST_IT))) + 
									CASE WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1 THEN 
										0
									ELSE 
										V_EST_NF_ENT.VLR_ICMS_RET
									END + ISNULL(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0) - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
																							 ELSE 0 
																						END - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
																								   ELSE 0 
																							   END
						END
					ELSE 
						CASE WHEN CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_OUTROS) > 0 THEN 
							CASE WHEN V_EST_NF_ENT.VLR_FRETE = 0 THEN 
								(((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT +  V_EST_NF_ENT.VLR_FECOP_ST_IT + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_OUTROS) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_OUTROS)), 9) * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT + V_EST_NF_ENT.VLR_FECOP_ST_IT))) + 
								CASE WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1 THEN 
									0
								ELSE 
									V_EST_NF_ENT.VLR_ICMS_RET
								END - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
										   ELSE 0 
									   END
							ELSE 
								(((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT +  V_EST_NF_ENT.VLR_FECOP_ST_IT + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_OUTROS) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_OUTROS)), 9) * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT + V_EST_NF_ENT.VLR_FECOP_ST_IT)) + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_FRETE) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_FRETE)), 9) * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT + V_EST_NF_ENT.VLR_FECOP_ST_IT))) + 
									CASE WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1 THEN  0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
									END - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
											   ELSE 0 
										   END
									END
							ELSE 0
						END
				END AS VLR_COMPRA,
				MERC.NM_FABRIC,
				MERC.DS_ARV_MERC_CATEG,
				MERC.DS_ARV_MERC_DEPTO,
				MERC.DS_ARV_MERC_AREA_ATEND,
				MERC.DS_ARV_MERC_SEG,
				MERC.DS_ARV_MERC_LINHA,
				MERC.DS_ARV_MERC_CONSUMO,
				MERC.DS_ARV_MERC_MIX,
				MERC.DS_ARV_MERC_PAPEL,
				MERC.DS_ARV_MERC_FAMILIA,
				MERC.DS_ARV_MERC_MTZ_BCG,
				V_EST_NF_ENT.NM_ORIG_FANT,
				CASE
					WHEN V_EST_NF_ENT.TP_MOV = 0
					THEN 'COMPRAS'
					ELSE 'OUTRAS ENTRADAS'
				END TIPO_ENTRADA,
				TIPO_FORNECEDOR,
				CASE
					WHEN V_EST_NF_ENT.ATU_EST = 1
					THEN 'ACRESCENTOU ESTOQUE'
					ELSE 'NAO ACRESCENTOU ESTOQUE'
				END AS ATU_EST,
				ISNULL(CRED.NR_DP, 0) AS NR_DP_PAG,
				CASE
					WHEN CRED.CD_NF IS NULL
					THEN 'NAO'
					ELSE 'SIM'
				END AS CONTASPAGAR,
				CASE
					WHEN V_EST_NF_ENT.EXPORT_NF_ESCRITA = 0
					THEN 'SIM'
					ELSE 'NAO'
				END AS EXPORT_NF_ESCRITA,
				CASE
					WHEN V_EST_NF_ENT.LISTA_PROD = 0
					THEN '0 - POSITIVA'
					WHEN V_EST_NF_ENT.LISTA_PROD = 1
					THEN '1 - NEGATIVA'
					WHEN V_EST_NF_ENT.LISTA_PROD = 2
					THEN '2 - NEUTRA'
					WHEN V_EST_NF_ENT.LISTA_PROD = 3
					THEN '3 - NAO USA LISTA'
				END AS LISTA_PROD,
				CASE
					WHEN V_EST_NF_ENT.PIS_COFINS = 0
					THEN 'NAO'
					WHEN V_EST_NF_ENT.PIS_COFINS = 1
					THEN 'SIM'
				END AS PIS_COFINS,

				V_EST_NF_ENT.NR_NCM,
				V_EST_NF_ENT.PERC_IVA,
				V_EST_NF_ENT.ALIQ_ICMS,
				V_EST_NF_ENT.CGC_CPF CNPJ,
				V_EST_NF_ENT.UF UF_EMISSOR,
				V_EST_NF_ENT.UF_DESTINATARIO UF,
				ROUND(V_EST_NF_ENT.VLR_ICMS_RET, 2) AS VLR_ICMS_RET,
				V_EST_NF_ENT.VLR_CRED_BASE_SN,
				V_EST_NF_ENT.VLR_CRED_ICMS_SN,
				V_EST_NF_ENT.PERC_DESC_FINAN,
				V_EST_NF_ENT.VLR_DESC_FINAN_PROD,
				CASE
					WHEN V_EST_NF_ENT.ISENTO = 1
					THEN V_EST_NF_ENT.VLR_TOT_IT
					ELSE 0
				END AS VLR_ISENTO,
			   CASE
					WHEN V_EST_NF_ENT.SUBS_TRIB_ANT = 1
					THEN (V_EST_NF_ENT.VLR_TOT_IT/ V_EST_NF_ENT.QT_IT)
					ELSE CASE
							WHEN(ICMS + SUBS_TRIB + ICMS_RD) > 1
							THEN (V_EST_NF_ENT.VLR_TOT_IT/ V_EST_NF_ENT.QT_IT ) - V_EST_NF_ENT.VLR_BASE_ICMS_IT
							ELSE 0
						END
				END + ISNULL(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0) AS VLR_OUTROS,

				ISNULL(V_EST_NF_ENT.NR_AUTORIZADOR,0) + SPACE(1),
				V_EST_NF_ENT.MODELO,
				V_EST_NF_ENT.PERC_ALIQ_PIS,
				V_EST_NF_ENT.PERC_ALIQ_COFINS,
				V_EST_NF_ENT.VLR_BASE_PIS,
				V_EST_NF_ENT.VLR_BASE_COFINS,
				V_EST_NF_ENT.VLR_PIS,
				V_EST_NF_ENT.VLR_COFINS,
				V_EST_NF_ENT.PERC_REDU_BASE_SUBS_IT,
				V_EST_NF_ENT.PERC_REDU_BASE_ICMS_IT,
				V_EST_NF_ENT.CST_PIS,
				V_EST_NF_ENT.ORIGEM_PRODUTO,
				V_EST_NF_ENT.VLR_ICMS_SUBS_DARE,
				(V_EST_NF_ENT.QT_IT * CASE
											WHEN ISNULL(MERC.VLR_FABRICA, 0) > 0
											THEN ISNULL(MERC.VLR_FABRICA, 0)
											ELSE ISNULL(V_EST_PROD_PRECO_TBL.VLR_FORN, 0)
										END) AS VLR_FABRICA,
				ISNULL(V_EST_PROD_PRECO_TBL.VLR_FORN, 0) AS VLR_SHELIN,
				ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0) AS VLR_ICMS_DESONERADO,
				MERC.DS_MC,
				ISNULL(MERC.NR_CEST, '') NR_CEST,
				left(ISNULL(V_EST_NF_ENT.OBS1,''),50) AS OBS1,			
				CASE WHEN LEN(V_EST_NF_ENT.OBS1) > 50 THEN LEFT(RIGHT(V_EST_NF_ENT.OBS1,LEN(V_EST_NF_ENT.OBS1) - 50),50) ELSE '' END AS OBS2,
				CASE WHEN LEN(V_EST_NF_ENT.OBS1) > 100 THEN RIGHT(V_EST_NF_ENT.OBS1,LEN(V_EST_NF_ENT.OBS1) - 100) ELSE '' END AS OBS3,
				left(ISNULL(V_EST_NF_ENT.OBS2,''),50) AS OBS4,
										 
				CASE WHEN LEN(V_EST_NF_ENT.OBS2) > 50 THEN LEFT(RIGHT(V_EST_NF_ENT.OBS2,LEN(V_EST_NF_ENT.OBS2) - 50),50) ELSE '' END AS OBS5,
				left(ISNULL(V_EST_NF_ENT.OBS4,''),50) AS OBS6,
				left(ISNULL(V_EST_NF_ENT.OBS5,''),50) AS OBS7,
				VLR_BASE_FECOP_ST_IT,
				V_EST_NF_ENT.PERC_FECOP_ST,
				VLR_FECOP_ST_IT,
				VLR_BASE_FECOP_RET_IT,
				V_EST_NF_ENT.PERC_FECOP_RET,
				V_EST_NF_ENT.VLR_FECOP_RET_IT,
				EST_PED_VD.OBS,
				V_EST_NF_ENT.VLR_FECOP,
				V_EST_NF_ENT.VLR_PMC_DAR_IT,
				V_EST_NF_ENT.VLR_PMPF_DAR_IT,
			 
				 CASE
					WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 0
					THEN '0 - MVA'
					WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 1
					THEN '1 - PAUTA'
					WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 2
					THEN '2 - CARGA TRIB'
					WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 3
					THEN '3 - PREÇO PMC'
					WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 4
					THEN '4 - PREÇO PMPF'
					ELSE ''
				END AS TP_SUBS_DAR_IT
				,'' AS NR_LOTE
				,V_EST_NF_ENT.CD_EMP
				,V_EST_NF_ENT.CD_NF
				,ISNULL(V_EST_NF_ENT.CD_BENEF_IT,'') AS CD_BENEF
				,ISNULL(MOTIVO.DESCRICAO,'') AS MOTIVO_DESONERADO_ICMS
				,ISNULL(V_EST_NF_ENT.VLR_ICMS_SUBSTITUTO,0) AS VLR_ICMS_SUBSTITUTO
			FROM 		 
				V_EST_NF_ENT 
				INNER JOIN  #RsNotaA  B ON 
				V_EST_NF_ENT.CD_EMP	= B.CD_EMP AND										 
				V_EST_NF_ENT.CD_FILIAL = B.CD_FILIAL AND
				V_EST_NF_ENT.CD_NF		= B.CD_NF 
			 
				LEFT JOIN EST_NF_ENT_PED_VD ON
				V_EST_NF_ENT.CD_EMP = EST_NF_ENT_PED_VD.CD_EMP AND
				V_EST_NF_ENT.CD_FILIAL = EST_NF_ENT_PED_VD.CD_FILIAL AND
				V_EST_NF_ENT.CD_NF = EST_NF_ENT_PED_VD.CD_NF
			 
				LEFT JOIN EST_PED_VD ON
				EST_NF_ENT_PED_VD.CD_EMP = EST_PED_VD.CD_EMP AND
				EST_NF_ENT_PED_VD.CD_FILIAL = EST_PED_VD.CD_FILIAL AND
				EST_NF_ENT_PED_VD.CD_PED = EST_PED_VD.CD_PED
			   
				INNER JOIN EST_PROD_CPL C ON 
				V_EST_NF_ENT.CD_EMP	= C.CD_EMP AND 
				V_EST_NF_ENT.CD_PROD	= C.CD_PROD AND 
				V_EST_NF_ENT.CD_FILIAL	= C.CD_FILIAL 
                 
				INNER JOIN #EST_PROD_ARV_MERC MERC ON 
				C.CD_EMP = MERC.CD_EMP AND 
				C.CD_PROD = MERC.CD_PROD  
			  
				LEFT OUTER JOIN V_EST_PROD_PRECO_TBL ON 
				V_EST_NF_ENT.CD_EMP = V_EST_PROD_PRECO_TBL.CD_EMP
				AND V_EST_NF_ENT.CD_FILIAL = V_EST_PROD_PRECO_TBL.CD_FILIAL
				AND V_EST_NF_ENT.CD_PROD = V_EST_PROD_PRECO_TBL.CD_PROD

				LEFT JOIN #TMPRESULT2 SC ON 
				V_EST_NF_ENT.CD_EMP = SC.CD_EMP
				AND V_EST_NF_ENT.CD_FILIAL = SC.CD_FILIAL
				AND V_EST_NF_ENT.CD_NF = SC.CD_NF
				AND V_EST_NF_ENT.CD_PROD = SC.CD_PROD		   							
					
				LEFT OUTER JOIN #RsNotaFiscalDuplicata CRED ON 
				V_EST_NF_ENT.CD_EMP = CRED.CD_EMP AND
				V_EST_NF_ENT.CD_FILIAL = CRED.CD_FILIAL AND
				V_EST_NF_ENT.CD_NF = CRED.CD_NF 
				OUTER APPLY (SELECT TOP 1 MOTIVO.DESCRICAO FROM TBL_ICMS_DESONERADO_MOTIVO MOTIVO WHERE V_EST_NF_ENT.ICMS_DESONERADO_MOTIVO = MOTIVO.CD_MOTIVO) MOTIVO	  

			WHERE 
				V_EST_NF_ENT.CD_EMP =@CD_EMP
				AND V_EST_NF_ENT.DT_ENT BETWEEN @DT_INI AND @DT_FIM  
				AND V_EST_NF_ENT.CD_FORN_FILIAL = CASE  WHEN @GRP = 1  THEN 0
											WHEN @GRP = 0 THEN  V_EST_NF_ENT.CD_FORN_FILIAL
											END 

				AND V_EST_NF_ENT.STS_NF = CASE  WHEN @CANCEL = 0  THEN 0
										WHEN @CANCEL = 1 THEN  V_EST_NF_ENT.STS_NF
										END 
				and  case when @cd_forn = '' then	 - 1 
						else  V_EST_NF_ENT.CD_FORN end in (select CD_FORN from #TMPFORN)  						 
				AND V_EST_NF_ENT.QT_IT <>0 ; 

		END
 /*********************************************************************************************************************************/	
			PRINT 'INSERT 22 '+CONVERT(VARCHAR, GETDATE(), 108);
			INSERT INTO #TmpResult
			SELECT 
				V_EST_NF_ENT_CPL.DT_ENT,
				CASE
				WHEN V_EST_NF_ENT_CPL.STS_NF = 0
				THEN 'NORMAL'
				ELSE 'CANCELADA'
				END STS_NF,
				V_EST_NF_ENT_CPL.SERIE,
				V_EST_NF_ENT_CPL.CD_ORIG,
				V_EST_NF_ENT_CPL.DT_EMI_NF,
				V_EST_NF_ENT_CPL.NR_NF,
				V_EST_NF_ENT_CPL.CD_FILIAL,
				0 AS CD_PROD,
				'NOTA FISCAL SOMENTE CABECALHO' AS DS_PROD,
				'' AS CD_BARRA,
				0 AS QT_IT,
				0 AS QT_IT_LOTE,
				V_EST_NF_ENT_CPL.VLR_TOT_PROD AS VLR_IT_TOTAL_BRUTO,
				0 AS VLR_IT,
				0 AS VLR_DESC,
				0 AS VLR_TOT_IT,
				0 AS VLR_CUSTO_MD,
				V_EST_NF_ENT_CPL.VLR_BASE_ICMS,
				V_EST_NF_ENT_CPL.VLR_ICMS,
				V_EST_NF_ENT_CPL.VLR_BASE_ICMS_SUBS,
				V_EST_NF_ENT_CPL.VLR_ICMS_SUBS,
				CASE
				WHEN V_EST_NF_ENT_CPL.VLR_ICMS_SUBS = 0
				THEN V_EST_NF_ENT_CPL.VLR_ICMS
				ELSE 0
				END VLR_ICMS_REAL,
				V_EST_NF_ENT_CPL.VLR_IPI,
				'000' AS CD_TRIB_FC,
				LEFT(CFOP, 5) AS CFOP,
				DS_MOV_OP,
				'D' AS DS_SIGLA,
				V_EST_NF_ENT_CPL.VLR_NF AS VLR_PRC_CUSTO,
				0 VLR_PMC,
				0 AS VLR_OUTRAS_DESPESAS,
				0 AS VLR_FRETE,
				V_EST_NF_ENT_CPL.VLR_NF AS VLR_COMPRA,
				'NAO DEFINIDO' AS NM_FABRIC,
				'NAO DEFINIDO' AS DS_ARV_MERC_CATEG,
				'NAO DEFINIDO' AS DS_ARV_MERC_DEPTO,
				'NAO DEFINIDO' AS DS_ARV_MERC_AREA_ATEND,
				'NAO DEFINIDO' AS DS_ARV_MERC_SEG,
				'NAO DEFINIDO' AS DS_ARV_MERC_LINHA,
				'NAO DEFINIDO' AS DS_ARV_MERC_CONSUMO,
				'NAO DEFINIDO' AS DS_ARV_MERC_MIX,
				'NAO DEFINIDO' AS DS_ARV_MERC_PAPEL,
				'NAO DEFINIDO' AS DS_ARV_MERC_FAMILIA,
				'NAO DEFINIDO' AS DS_ARV_MERC_MTZ_BCG,
				NM_ORIG_FANT,
				'NOTAS FISCAIS SOMENTE CABECALHO' AS TIPO_ENTRADA,
				TIPO_FORNECEDOR,
				'NAO ACRESCENTOU ESTOQUE' AS ATU_EST,
				ISNULL(PG_CRED_EST_NF_ENT.NR_DP, 0) AS NR_DP_PAG,
				CASE
				WHEN PG_CRED_EST_NF_ENT.CD_NF IS NULL
				THEN 'NAO'
				ELSE 'SIM'
				END AS CONTASPAGAR,
				CASE
				WHEN V_EST_NF_ENT_CPL.EXPORT_NF_ESCRITA = 0
				THEN 'SIM'
				ELSE 'NAO'
				END AS EXPORT_NF_ESCRITA,
				'NAO DEFINIDO' AS LISTA_PROD,
				'NAO' AS PIS_COFINS,
				'' AS NR_NCM,
				0 AS PERC_IVA,
				0 AS ALIQ_ICMS,
				V_EST_NF_ENT_CPL.CGC_CPF CNPJ,
				V_EST_NF_ENT_CPL.UF UF_EMISSOR,
				V_EST_NF_ENT_CPL.UF_DESTINATARIO UF,
				0 AS VLR_ICMS_RET,
				0 AS VLR_CRED_BASE_SN,
				0 AS VLR_CRED_ICMS_SN,
				0 AS PERC_DESC_FINAN,
				0 AS VLR_DESC_FINAN_PROD,
				0 AS VLR_ISENTO,
				0 AS VLR_OUTROS,
				ISNULL(V_EST_NF_ENT_CPL.NR_AUTORIZADOR,0) + SPACE(1),
				V_EST_NF_ENT_CPL.MODELO,
				0 AS PERC_ALIQ_PIS,
				0 AS PERC_ALIQ_COFINS,
				0 AS VLR_BASE_PIS,
				0 AS VLR_BASE_COFINS,
				0 AS VLR_PIS,
				0 AS VLR_COFINS,
				0 AS PERC_REDU_BASE_SUBS_IT,
				0 AS PERC_REDU_BASE_ICMS_IT,
				0 AS CST_PIS,
				0 AS ORIGEM_PRODUTO,
				0 AS VLR_ICMS_SUBS_DARE,
				0 AS VLR_FABRICA,
				0 AS VLR_SHELIN,
				0 AS VLR_ICMS_DESONERADO,
				'' AS DS_MC,
				'' AS NR_CEST,
				'' AS OBS1,
				'' AS OBS2,
				'' AS OBS3,
				'' AS OBS4,
				'' AS OBS5,
				'' AS OBS6,
				'' AS OBS7,
				0 AS VLR_BASE_FECOP_ST_IT,
				0 AS PERC_FECOP_ST,
				0 AS VLR_FECOP_ST_IT,
				0 AS VLR_BASE_FECOP_RET_IT,
				0 AS PERC_FECOP_RET,
				0 AS VLR_FECOP_RET_IT,
				EST_PED_VD.OBS,
				0 AS VLR_FECOP,
				0 AS  VLR_PMC_DAR_IT,
				0 AS VLR_PMPF_DAR_IT,	    
				'' AS  TP_SUBS_DAR_IT   
				,'' AS NR_LOTE
				,V_EST_NF_ENT_CPL.CD_EMP
				,V_EST_NF_ENT_CPL.CD_NF
				,'' AS CD_BENEF
				,'' AS MOTIVO_DESONERADO_ICMS
				,0 AS VLR_ICMS_SUBSTITUTO
			FROM V_EST_NF_ENT_CPL 
				LEFT JOIN EST_NF_ENT_PED_VD ON
				V_EST_NF_ENT_CPL.CD_EMP = EST_NF_ENT_PED_VD.CD_EMP AND
				V_EST_NF_ENT_CPL.CD_FILIAL = EST_NF_ENT_PED_VD.CD_FILIAL AND
				V_EST_NF_ENT_CPL.CD_NF = EST_NF_ENT_PED_VD.CD_NF
				LEFT JOIN EST_PED_VD ON
				EST_NF_ENT_PED_VD.CD_EMP = EST_PED_VD.CD_EMP AND
				EST_NF_ENT_PED_VD.CD_FILIAL = EST_PED_VD.CD_FILIAL AND
				EST_NF_ENT_PED_VD.CD_PED = EST_PED_VD.CD_PED
				inner join #TmpFilial fl on 
				V_EST_NF_ENT_CPL.CD_FILIAL = fl.CD_FILIAL 
				LEFT OUTER JOIN PG_CRED_EST_NF_ENT ON 
				V_EST_NF_ENT_CPL.CD_EMP = PG_CRED_EST_NF_ENT.CD_EMP AND 
				V_EST_NF_ENT_CPL.CD_FILIAL = PG_CRED_EST_NF_ENT.CD_FILIAL AND 
				V_EST_NF_ENT_CPL.CD_NF = PG_CRED_EST_NF_ENT.CD_NF
				 LEFT OUTER JOIN #RsNotaFiscalDuplicata CRED ON 
				 V_EST_NF_ENT_CPL.CD_EMP = CRED.CD_EMP AND
				 V_EST_NF_ENT_CPL.CD_FILIAL = CRED.CD_FILIAL AND
				 V_EST_NF_ENT_CPL.CD_NF = CRED.CD_NF				 
			WHERE 
				V_EST_NF_ENT_CPL.CD_EMP = 1 
				and  case when @cd_forn = '' then	 - 1 
					else  V_EST_NF_ENT_CPL.CD_FORN end in (select CD_FORN from #TMPFORN) 
				AND V_EST_NF_ENT_CPL.DT_ENT between @DT_INI AND @DT_FIM
				AND V_EST_NF_ENT_CPL.STS_NF = 0;
	   END 
	   ----DATA DE EMISSAO
	   ELSE
	   BEGIN
		CREATE TABLE #RsNotaE  (CD_EMP INT,CD_FILIAL INT,CD_NF INT, dt_ent datetime) 
		insert into #RsNotaE
		SELECT 
			e.cd_emp, e.cd_filial, e.cd_nf, e.dt_ent 
		from 
			est_nf_ent e
		WHERE 
			e.CD_EMP =@CD_EMP
			AND e.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM  
			and  case when @cd_forn = '' then	 - 1 
					else  e.CD_FORN end in (select CD_FORN from #TMPFORN)  
			AND e.STS_NF = CASE  WHEN @CANCEL = 0  THEN 0
					WHEN @CANCEL = 1 THEN  e.STS_NF END 	 
		PRINT 'INSERT 23 '+CONVERT(VARCHAR, GETDATE(), 108);

		IF @EXIBIR_LOTE = 1
		BEGIN
			INSERT INTO #TMPRESULT
            SELECT 
/*
                   V_EST_NF_ENT.DT_ENT,
                   CASE
				    WHEN V_EST_NF_ENT.STS_NF = 0
				    THEN 'NORMAL'
				    ELSE 'CANCELADA'
                   END STS_NF,
                   V_EST_NF_ENT.SERIE,
                   V_EST_NF_ENT.CD_ORIG,
                   V_EST_NF_ENT.DT_EMI_NF,
                   V_EST_NF_ENT.NR_NF,
                   V_EST_NF_ENT.CD_FILIAL,
                   V_EST_NF_ENT.CD_PROD,				   
                   MERC.DS_PROD,
				   COALESCE((SELECT TOP 1 CD_BARRA FROM EST_PROD_CD_BARRA WHERE CD_EMP = MERC.CD_EMP AND CD_PROD = MERC.CD_PROD AND COALESCE(EAN_CAIXA_FECHADA,0) = 0 AND COALESCE(NAO_ENVIA_WMS,0) = 0 AND COALESCE(FLAG_PRE_VENCIDOS,0) = 0 ORDER BY DT_CAD DESC),'') AS CD_BARRA,
                   V_EST_NF_ENT.QT_IT,
                   V_EST_NF_ENT.VLR_IT * V_EST_NF_ENT.QT_IT AS VLR_IT_TOTAL_BRUTO,
                   CONVERT(FLOAT,V_EST_NF_ENT.VLR_TOT_IT)/CONVERT(FLOAT,V_EST_NF_ENT.QT_IT) AS VLR_IT,
                   V_EST_NF_ENT.VLR_DESC_IT AS VLR_DESC,
                   V_EST_NF_ENT.QT_IT * (V_EST_NF_ENT.VLR_IT - (V_EST_NF_ENT.VLR_DESC_IT / CONVERT(FLOAT,V_EST_NF_ENT.QT_IT))) AS VLR_TOT_IT,
                   ROUND((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_CUSTO_MD), 2) AS VLR_CUSTO_MD,
                   V_EST_NF_ENT.VLR_BASE_ICMS_IT AS VLR_BASE_ICMS,
                   V_EST_NF_ENT.VLR_ICMS_IT,
                   V_EST_NF_ENT.VLR_BASE_SUBS_IT AS VLR_BASE_SUBS,
                   V_EST_NF_ENT.VLR_ICMS_SUBS_IT AS VLR_ICMS_SUBS,
                   CASE
				   WHEN COALESCE(SC.CD_PROD,0) = 0
                       THEN 0
                       ELSE SC.VLR_ICMS_REC
                   END VLR_ICMS_REAL,
                   V_EST_NF_ENT.VLR_IPI_IT AS VLR_IPI,
                   V_EST_NF_ENT.CD_TRIB_FC,
                   LEFT(V_EST_NF_ENT.CFOP, 5) AS CFOP,
                   V_EST_NF_ENT.DS_MOV_OP_USUAL AS DS_MOV_OP,
                   CASE WHEN C.CD_SIGLA = 4 THEN 'D' 
						WHEN C.CD_SIGLA = 3 THEN 'C' 
						WHEN C.CD_SIGLA = 2 THEN 'B' 
						WHEN C.CD_SIGLA = 1 THEN 'A' 
						WHEN C.CD_SIGLA = 5 THEN 'AA' 
						ELSE 'D' END DS_SIGLA,
                   (V_EST_NF_ENT.VLR_PRC_CUSTO * V_EST_NF_ENT.QT_IT) AS VLR_PRC_CUSTO,
                   CASE WHEN ISNULL(V_EST_NF_ENT.VLR_PMC_DAR_IT, 0 )> 0 THEN V_EST_NF_ENT.VLR_PMC_DAR_IT
						ELSE ISNULL( V_EST_NF_ENT.VLR_PROD_PMC, 0 )
					END			AS VLR_PMC,
					CASE WHEN COALESCE(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0) = 0
						THEN VLR_OUTROS_CABE_RATEIO
						ELSE V_EST_NF_ENT.VLR_OUTRAS_DESPESAS
					END AS VLR_OUTRAS_DESPESAS,
                   VLR_FRETE_CABE_RATEIO AS VLR_FRETE,
                   CASE
                       WHEN V_EST_NF_ENT.VLR_OUTROS = 0
                       THEN CASE
                                WHEN V_EST_NF_ENT.VLR_FRETE = 0 THEN 
									(((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT +  V_EST_NF_ENT.VLR_FECOP_ST_IT) + 
									CASE WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1 THEN 
										0
									ELSE 
										V_EST_NF_ENT.VLR_ICMS_RET
									END + ISNULL(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0) - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
																					         ELSE 0 
																				         END
                                ELSE 
									(((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT +  V_EST_NF_ENT.VLR_FECOP_ST_IT + (ROUND((CONVERT( FLOAT, V_EST_NF_ENT.VLR_FRETE) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_FRETE)), 9) * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT + V_EST_NF_ENT.VLR_FECOP_ST_IT))) + 
										CASE WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1 THEN 
											0
										ELSE 
											V_EST_NF_ENT.VLR_ICMS_RET
                                        END + ISNULL(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0) - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
																								 ELSE 0 
																							  END - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
																										 ELSE 0 
																									 END
                            END
                       ELSE 
							CASE WHEN CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_OUTROS) > 0 THEN 
								CASE WHEN V_EST_NF_ENT.VLR_FRETE = 0 THEN 
									(((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT +  V_EST_NF_ENT.VLR_FECOP_ST_IT + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_OUTROS) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_OUTROS)), 9) * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT + V_EST_NF_ENT.VLR_FECOP_ST_IT))) + 
									CASE WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1 THEN 
										0
                                    ELSE 
										V_EST_NF_ENT.VLR_ICMS_RET
									END - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
											   ELSE 0 
										   END
                                ELSE 
									(((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT +  V_EST_NF_ENT.VLR_FECOP_ST_IT + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_OUTROS) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_OUTROS)), 9) * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT + V_EST_NF_ENT.VLR_FECOP_ST_IT)) + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_FRETE) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_FRETE)), 9) * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT + V_EST_NF_ENT.VLR_FECOP_ST_IT))) + 
										CASE WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1 THEN 
											0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ELSE ROUND(V_EST_NF_ENT.VLR_ICMS_RET, 2)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  END - ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
                                     END
                                ELSE 0
                            END
                   END AS VLR_COMPRA,
                   MERC.NM_FABRIC,
                   MERC.DS_ARV_MERC_CATEG,
                   MERC.DS_ARV_MERC_DEPTO,
                   MERC.DS_ARV_MERC_AREA_ATEND,
                   MERC.DS_ARV_MERC_SEG,
                   MERC.DS_ARV_MERC_LINHA,
                   MERC.DS_ARV_MERC_CONSUMO,
                   MERC.DS_ARV_MERC_MIX,
                   MERC.DS_ARV_MERC_PAPEL,
                   MERC.DS_ARV_MERC_FAMILIA,
                   MERC.DS_ARV_MERC_MTZ_BCG,
                   V_EST_NF_ENT.NM_ORIG_FANT,
					CASE
						WHEN V_EST_NF_ENT.TP_MOV = 0
						THEN 'COMPRAS'
						ELSE 'OUTRAS ENTRADAS'
					END TIPO_ENTRADA,
                   TIPO_FORNECEDOR,
                   CASE
                       WHEN V_EST_NF_ENT.ATU_EST = 1
                       THEN 'ACRESCENTOU ESTOQUE'
                       ELSE 'NAO ACRESCENTOU ESTOQUE'
                   END AS ATU_EST,
                   ISNULL(CRED.NR_DP, 0) AS NR_DP_PAG,
                   CASE
                       WHEN CRED.CD_NF IS NULL
                       THEN 'NAO'
                       ELSE 'SIM'
                   END AS CONTASPAGAR,
                   CASE
                       WHEN V_EST_NF_ENT.EXPORT_NF_ESCRITA = 0
                       THEN 'SIM'
                       ELSE 'NAO'
                   END AS EXPORT_NF_ESCRITA,
                   CASE
                       WHEN V_EST_NF_ENT.LISTA_PROD = 0
                       THEN '0 - POSITIVA'
                       WHEN V_EST_NF_ENT.LISTA_PROD = 1
                       THEN '1 - NEGATIVA'
                       WHEN V_EST_NF_ENT.LISTA_PROD = 2
                       THEN '2 - NEUTRA'
                       WHEN V_EST_NF_ENT.LISTA_PROD = 3
                       THEN '3 - NAO USA LISTA'
                   END AS LISTA_PROD,
                   CASE
                       WHEN V_EST_NF_ENT.PIS_COFINS = 0
                       THEN 'NAO'
                       WHEN V_EST_NF_ENT.PIS_COFINS = 1
                       THEN 'SIM'
                   END AS PIS_COFINS,
                   V_EST_NF_ENT.NR_NCM,
                   V_EST_NF_ENT.PERC_IVA,
                   V_EST_NF_ENT.ALIQ_ICMS,
                   V_EST_NF_ENT.CGC_CPF CNPJ,
				   V_EST_NF_ENT.UF UF_EMISSOR,
                   V_EST_NF_ENT.UF_DESTINATARIO UF,
				   ROUND(V_EST_NF_ENT.VLR_ICMS_RET, 2) AS VLR_ICMS_RET,
                   V_EST_NF_ENT.VLR_CRED_BASE_SN,
                   V_EST_NF_ENT.VLR_CRED_ICMS_SN,
                   V_EST_NF_ENT.PERC_DESC_FINAN,
                   V_EST_NF_ENT.VLR_DESC_FINAN_PROD,
                   CASE
                       WHEN V_EST_NF_ENT.ISENTO = 1
                       THEN V_EST_NF_ENT.VLR_TOT_IT
                       ELSE 0
                   END AS VLR_ISENTO,
                   CASE
                       WHEN V_EST_NF_ENT.SUBS_TRIB_ANT = 1
                       THEN V_EST_NF_ENT.VLR_TOT_IT
                       ELSE CASE
                                WHEN(ICMS + SUBS_TRIB + ICMS_RD) > 1
                                THEN V_EST_NF_ENT.VLR_TOT_IT - V_EST_NF_ENT.VLR_BASE_ICMS_IT
                                ELSE 0
                            END
                   END + ISNULL(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0) AS VLR_OUTROS,
                   V_EST_NF_ENT.NR_AUTORIZADOR,
                   V_EST_NF_ENT.MODELO,
                   V_EST_NF_ENT.PERC_ALIQ_PIS,
                   V_EST_NF_ENT.PERC_ALIQ_COFINS,
                   V_EST_NF_ENT.VLR_BASE_PIS,
                   V_EST_NF_ENT.VLR_BASE_COFINS,
                   V_EST_NF_ENT.VLR_PIS,
                   V_EST_NF_ENT.VLR_COFINS,
                   V_EST_NF_ENT.PERC_REDU_BASE_SUBS_IT,
                   V_EST_NF_ENT.PERC_REDU_BASE_ICMS_IT,
                   V_EST_NF_ENT.CST_PIS,
                   V_EST_NF_ENT.ORIGEM_PRODUTO,
                   V_EST_NF_ENT.VLR_ICMS_SUBS_DARE,
                   (V_EST_NF_ENT.QT_IT * CASE
                                             WHEN ISNULL(MERC.VLR_FABRICA, 0) > 0
                                             THEN ISNULL(MERC.VLR_FABRICA, 0)
                                             ELSE ISNULL(V_EST_PROD_PRECO_TBL.VLR_FORN, 0)
                                         END) AS VLR_FABRICA,
				ISNULL(V_EST_PROD_PRECO_TBL.VLR_FORN, 0) AS VLR_SHELIN,
				ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0) AS VLR_ICMS_DESONERADO,
				MERC.DS_MC,
				ISNULL(MERC.NR_CEST, '') NR_CEST,
				left(ISNULL(V_EST_NF_ENT.OBS1,''),50) AS OBS1,			
				CASE WHEN LEN(V_EST_NF_ENT.OBS1) > 50 THEN LEFT(RIGHT(V_EST_NF_ENT.OBS1,LEN(V_EST_NF_ENT.OBS1) - 50),50) ELSE '' END AS OBS2,
				CASE WHEN LEN(V_EST_NF_ENT.OBS1) > 100 THEN RIGHT(V_EST_NF_ENT.OBS1,LEN(V_EST_NF_ENT.OBS1) - 100) ELSE '' END AS OBS3,
				left(ISNULL(V_EST_NF_ENT.OBS2,''),50) AS OBS4,
				CASE WHEN LEN(V_EST_NF_ENT.OBS2) > 50 THEN LEFT(RIGHT(V_EST_NF_ENT.OBS2,LEN(V_EST_NF_ENT.OBS2) - 50),50) ELSE '' END AS OBS5,
				left(ISNULL(V_EST_NF_ENT.OBS4,''),50) AS OBS6,
				left(ISNULL(V_EST_NF_ENT.OBS5,''),50) AS OBS7,
				VLR_BASE_FECOP_ST_IT,
				--PERC_FECOP_ST,
				V_EST_NF_ENT.PERC_FECOP_ST,
				VLR_FECOP_ST_IT,
				VLR_BASE_FECOP_RET_IT,
				--PERC_FECOP_RET,
				V_EST_NF_ENT.PERC_FECOP_RET,
				VLR_FECOP_RET_IT,
				EST_PED_VD.OBS,
				V_EST_NF_ENT.VLR_FECOP,
                V_EST_NF_ENT.VLR_PMC_DAR_IT,
			    V_EST_NF_ENT.VLR_PMPF_DAR_IT,
			    CASE
                WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 0
                THEN '0 - MVA'
                WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 1
                THEN '1 - PAUTA'
                WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 2
                THEN '2 - CARGA TRIB'
                WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 3
                THEN '3 - PREÇO PMC'
				WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 4
                THEN '4 - PREÇO PMPF'
				ELSE ''
				END AS TP_SUBS_DAR_IT
				,ISNULL(L.NR_LOTE,'') AS NR_LOTE
				,V_EST_NF_ENT.CD_EMP
				,V_EST_NF_ENT.CD_NF	
*/
			MAX(V_EST_NF_ENT.DT_ENT) AS DT_ENT,
			CASE WHEN MAX(V_EST_NF_ENT.STS_NF) = 0 THEN 
				'NORMAL'
			ELSE 
				'CANCELADA' 
			END STS_NF,
			MAX(V_EST_NF_ENT.SERIE) SERIE,
			MAX(V_EST_NF_ENT.CD_ORIG) CD_ORIG,
			MAX(V_EST_NF_ENT.DT_EMI_NF) AS DT_EMI_NF ,
			MAX(V_EST_NF_ENT.NR_NF) NR_NF,
			MAX(V_EST_NF_ENT.CD_FILIAL) CD_FILIAL,
			V_EST_NF_ENT.CD_PROD,
			MAX(MERC.DS_PROD) AS DS_PROD,
			COALESCE(
			(SELECT TOP 1 MAX(CD_BARRA) FROM EST_PROD_CD_BARRA WHERE CD_EMP = MAX(MERC.CD_EMP) AND CD_PROD = MAX(MERC.CD_PROD) AND COALESCE(EAN_CAIXA_FECHADA,0) = 0 AND COALESCE(NAO_ENVIA_WMS,0) = 0 AND COALESCE(FLAG_PRE_VENCIDOS,0) = 0 
			ORDER BY MAX(DT_CAD) DESC),'') AS CD_BARRA,
			--   V_EST_NF_ENT.QT_IT, ---- TIRAR ESSE
			MAX(COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD, V_EST_NF_ENT.QT_IT, 0)) AS QT_IT,
			--   V_EST_NF_ENT.QT_IT_LOTE, ---- TIRAR ESSE
			MAX(COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,0)) AS QT_IT_LOTE,
			--   V_EST_NF_ENT.VLR_IT * V_EST_NF_ENT.QT_IT AS VLR_IT_TOTAL_BRUTO,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IT) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT))),2) AS VLR_IT_TOTAL_BRUTO,
			--   CONVERT(FLOAT,V_EST_NF_ENT.VLR_TOT_IT)/CONVERT(FLOAT,V_EST_NF_ENT.QT_IT) AS VLR_IT,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT))),13) AS VLR_IT,
			--   V_EST_NF_ENT.VLR_DESC_IT AS VLR_DESC,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_DESC_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_DESC,
			--   V_EST_NF_ENT.QT_IT * (V_EST_NF_ENT.VLR_IT - (V_EST_NF_ENT.VLR_DESC_IT / CONVERT(FLOAT,V_EST_NF_ENT.QT_IT))) AS VLR_TOT_IT,
			ROUND(AVG((CONVERT(DECIMAL(38,10), COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)) * (CONVERT(DECIMAL(38,10),V_EST_NF_ENT.VLR_IT) - (CONVERT(DECIMAL(38,10),V_EST_NF_ENT.VLR_DESC_IT) / CONVERT(FLOAT,CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)))))),2) AS VLR_TOT_IT,
			--   ROUND((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_CUSTO_MD), 2) AS VLR_CUSTO_MD,
			ROUND(AVG(CONVERT(DECIMAL(38,10), COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)) 
			* (CONVERT(DECIMAL(38,10),V_EST_NF_ENT.VLR_CUSTO_MD))), 2) AS VLR_CUSTO_MD,	
			--   V_EST_NF_ENT.VLR_BASE_ICMS_IT AS VLR_BASE_ICMS,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_ICMS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) 
			* COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_BASE_ICMS,
			--   V_EST_NF_ENT.VLR_ICMS_IT,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) 
			* COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_ICMS_IT,
			--   V_EST_NF_ENT.VLR_BASE_SUBS_IT AS VLR_BASE_SUBS,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) 
			* COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_BASE_SUBS,
			--   V_EST_NF_ENT.VLR_ICMS_SUBS_IT AS VLR_ICMS_SUBS,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) 
			* COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_ICMS_SUBS,
			CASE
			WHEN COALESCE(MAX(SC.CD_PROD),0) = 0
				THEN 0
				ELSE 
					--SC.VLR_ICMS_REC
					ROUND(AVG((CONVERT(DECIMAL(38,10), SC.VLR_ICMS_REC) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) 
			END VLR_ICMS_REAL,
			--   V_EST_NF_ENT.VLR_IPI_IT AS VLR_IPI,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_IPI,
			MAX(V_EST_NF_ENT.CD_TRIB_FC) AS CD_TRIB_FC,
			MAX(LEFT(V_EST_NF_ENT.CFOP, 5)) AS CFOP,
			MAX(V_EST_NF_ENT.DS_MOV_OP_USUAL) AS DS_MOV_OP,
			MAX(CASE WHEN C.CD_SIGLA = 4 THEN 'D' 
				WHEN C.CD_SIGLA = 3 THEN 'C' 
				WHEN C.CD_SIGLA = 2 THEN 'B' 
				WHEN C.CD_SIGLA = 1 THEN 'A' 
				WHEN C.CD_SIGLA = 5 THEN 'AA' 
				ELSE 
			'D' 
			END) DS_SIGLA,
			--   (V_EST_NF_ENT.VLR_PRC_CUSTO * V_EST_NF_ENT.QT_IT) AS VLR_PRC_CUSTO,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_PRC_CUSTO) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT))),2) AS VLR_PRC_CUSTO,
			CASE WHEN ISNULL(MAX(V_EST_NF_ENT.VLR_PMC_DAR_IT), 0 ) > 0 THEN 
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_PMC_DAR_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) 
				ELSE 
					--ISNULL( V_EST_NF_ENT.VLR_PROD_PMC, 0 )
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_PROD_PMC) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) 
				* COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2)
			END AS VLR_PMC,
			CASE
			WHEN MAX(COALESCE(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0)) = 0
				THEN 
					--VLR_OUTROS_CABE_RATEIO
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_OUTROS_CABE_RATEIO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) 
				* COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) 
				ELSE 
					--V_EST_NF_ENT.VLR_OUTRAS_DESPESAS
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_OUTRAS_DESPESAS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) 
			END AS VLR_OUTRAS_DESPESAS,
			--VLR_FRETE_CABE_RATEIO AS VLR_FRETE,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FRETE_CABE_RATEIO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_FRETE,
			CASE WHEN MAX(V_EST_NF_ENT.VLR_OUTROS) = 0 THEN 
				CASE 
					WHEN MAX(V_EST_NF_ENT.VLR_FRETE) = 0 THEN 
						(((ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IT) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT))),2)) - ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_DESC_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2))
						+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
						+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
						+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
						)
						+
						CASE WHEN MAX(FLAG_ICMS_SUBST_PAGO_ANTERIOR) = 1 THEN 
							0
						ELSE 
							ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_RET) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
						END 
							+ ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_OUTRAS_DESPESAS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) 
												- CASE WHEN MAX(V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO) = 1  THEN 
													ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_DESONERADO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0)					
													ELSE 
														0 
												END 			
						ELSE 
							(((ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IT) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT))),2)) - ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_DESC_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2))
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							)
							+
							(
								ROUND((CONVERT( FLOAT, MAX(V_EST_NF_ENT.VLR_FRETE)) / CONVERT(FLOAT, MAX(V_EST_NF_ENT.VLR_NF) - MAX(V_EST_NF_ENT.VLR_FRETE))), 9)
								* (ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
								)				
							) +
							CASE WHEN MAX(FLAG_ICMS_SUBST_PAGO_ANTERIOR) = 1 THEN 
								0
							ELSE 
								ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_RET) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							END + ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_OUTRAS_DESPESAS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) 
									- CASE WHEN MAX(V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO) = 1  THEN 
										ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_DESONERADO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
									ELSE 
									0 
									END  - CASE WHEN MAX(V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO) = 1  THEN 
											ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_DESONERADO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
											ELSE  0 
											END
					END
				ELSE 
					CASE WHEN CONVERT(FLOAT, MAX(V_EST_NF_ENT.VLR_NF) - MAX(V_EST_NF_ENT.VLR_OUTROS)) > 0 THEN 
						CASE WHEN MAX(V_EST_NF_ENT.VLR_FRETE) = 0 THEN 
							(((ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IT) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT))),2)) - ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_DESC_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2))
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ (
							ROUND((CONVERT(FLOAT, MAX(V_EST_NF_ENT.VLR_OUTROS)) / CONVERT(FLOAT, MAX(V_EST_NF_ENT.VLR_NF) - MAX(V_EST_NF_ENT.VLR_OUTROS))), 9) 
							*(
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)				  
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)					
							)
							))				
							+
							CASE WHEN MAX(FLAG_ICMS_SUBST_PAGO_ANTERIOR) = 1 THEN 
								0
							ELSE 
								ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_RET) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2),0)
							END 
							- CASE WHEN MAX(V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO) = 1  THEN 
								ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_DESONERADO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2),0)
								ELSE 
								0 
								END
						ELSE 
							(((ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IT) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT))),2)) - ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_DESC_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2))
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ (
							ROUND((CONVERT(FLOAT, MAX(V_EST_NF_ENT.VLR_OUTROS)) / CONVERT(FLOAT, MAX(V_EST_NF_ENT.VLR_NF) - MAX(V_EST_NF_ENT.VLR_OUTROS))), 9) 
							*(
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_IPI_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
							+ ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)					
							)
							)
							) + 
							CASE WHEN MAX(FLAG_ICMS_SUBST_PAGO_ANTERIOR) = 1 THEN  0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
							END - CASE WHEN MAX(V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO) = 1  THEN 
								ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_DESONERADO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2),0)
										ELSE 0 
									END
							END
						ELSE 0
					END
			END AS VLR_COMPRA,
			MAX(MERC.NM_FABRIC) AS NM_FABRIC,
			MAX(MERC.DS_ARV_MERC_CATEG) AS DS_ARV_MERC_CATEG,
			MAX(MERC.DS_ARV_MERC_DEPTO) AS DS_ARV_MERC_DEPTO,
			MAX(MERC.DS_ARV_MERC_AREA_ATEND) AS DS_ARV_MERC_AREA_ATEND,
			MAX(MERC.DS_ARV_MERC_SEG) AS DS_ARV_MERC_SEG,
			MAX(MERC.DS_ARV_MERC_LINHA) AS DS_ARV_MERC_LINHA,
			MAX(MERC.DS_ARV_MERC_CONSUMO) AS DS_ARV_MERC_CONSUMO,
			MAX(MERC.DS_ARV_MERC_MIX) AS DS_ARV_MERC_MIX,
			MAX(MERC.DS_ARV_MERC_PAPEL) AS DS_ARV_MERC_PAPEL,
			MAX(MERC.DS_ARV_MERC_FAMILIA) AS DS_ARV_MERC_FAMILIA,
			MAX(MERC.DS_ARV_MERC_MTZ_BCG) AS DS_ARV_MERC_MTZ_BCG,
			MAX(V_EST_NF_ENT.NM_ORIG_FANT) AS NM_ORIG_FANT,
			CASE
				WHEN MAX(V_EST_NF_ENT.TP_MOV) = 0
				THEN 'COMPRAS'
				ELSE 'OUTRAS ENTRADAS'
			END TIPO_ENTRADA,
			MAX(TIPO_FORNECEDOR) AS TIPO_FORNECEDOR,
			CASE
				WHEN MAX(V_EST_NF_ENT.ATU_EST) = 1
				THEN 'ACRESCENTOU ESTOQUE'
				ELSE 'NAO ACRESCENTOU ESTOQUE'
			END AS ATU_EST,
			ISNULL(MAX(CRED.NR_DP), 0) AS NR_DP_PAG,
			MAX(CASE
				WHEN CRED.CD_NF IS NULL
				THEN 'NAO'
				ELSE 'SIM'
			END) AS CONTASPAGAR,
			MAX(CASE
				WHEN V_EST_NF_ENT.EXPORT_NF_ESCRITA = 0
				THEN 'SIM'
				ELSE 'NAO'
			END) AS EXPORT_NF_ESCRITA,
			MAX(CASE
				WHEN V_EST_NF_ENT.LISTA_PROD = 0
				THEN '0 - POSITIVA'
				WHEN V_EST_NF_ENT.LISTA_PROD = 1
				THEN '1 - NEGATIVA'
				WHEN V_EST_NF_ENT.LISTA_PROD = 2
				THEN '2 - NEUTRA'
				WHEN V_EST_NF_ENT.LISTA_PROD = 3
				THEN '3 - NAO USA LISTA'
			END) AS LISTA_PROD,
			MAX(CASE
				WHEN V_EST_NF_ENT.PIS_COFINS = 0
				THEN 'NAO'
				WHEN V_EST_NF_ENT.PIS_COFINS = 1
				THEN 'SIM'
			END) AS PIS_COFINS,
			MAX(V_EST_NF_ENT.NR_NCM) AS NR_NCM,
			MAX(V_EST_NF_ENT.PERC_IVA) AS PERC_IVA,
			MAX(V_EST_NF_ENT.ALIQ_ICMS) AS ALIQ_ICMS,
			MAX(V_EST_NF_ENT.CGC_CPF) AS CNPJ,
			MAX(V_EST_NF_ENT.UF) AS UF_EMISSOR,
			MAX(V_EST_NF_ENT.UF_DESTINATARIO) AS  UF,
			--ROUND(V_EST_NF_ENT.VLR_ICMS_RET, 2) AS VLR_ICMS_RET,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_RET) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_ICMS_RET,
			--MAX(V_EST_NF_ENT.VLR_CRED_BASE_SN) AS VLR_CRED_BASE_SN,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_CRED_BASE_SN) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_CRED_BASE_SN,    
			--MAX(V_EST_NF_ENT.VLR_CRED_ICMS_SN) AS VLR_CRED_ICMS_SN,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_CRED_ICMS_SN) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_CRED_ICMS_SN,
			--MAX(V_EST_NF_ENT.PERC_DESC_FINAN) AS PERC_DESC_FINAN,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.PERC_DESC_FINAN) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS PERC_DESC_FINAN,
			--MAX(V_EST_NF_ENT.VLR_DESC_FINAN_PROD) AS VLR_DESC_FINAN_PROD,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_DESC_FINAN_PROD) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_DESC_FINAN_PROD,
			CASE WHEN MAX(V_EST_NF_ENT.ISENTO) = 1 THEN 
				--V_EST_NF_ENT.VLR_TOT_IT
				ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
				ELSE 0
			END AS VLR_ISENTO,
			CASE
				WHEN MAX(V_EST_NF_ENT.SUBS_TRIB_ANT) = 1 THEN 
					--V_EST_NF_ENT.VLR_TOT_IT
					ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
				ELSE CASE WHEN(MAX(ICMS) + MAX(SUBS_TRIB) + MAX(ICMS_RD)) > 1 THEN 
						--V_EST_NF_ENT.VLR_TOT_IT - V_EST_NF_ENT.VLR_BASE_ICMS_IT
						ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_TOT_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
						-
						ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_ICMS_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9)
						ELSE 0
					END
			END + ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_OUTRAS_DESPESAS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) , 0) 
			AS VLR_OUTROS,
			MAX(ISNULL(V_EST_NF_ENT.NR_AUTORIZADOR,0)) + SPACE(1) AS NR_AUTORIZADOR,
			MAX(V_EST_NF_ENT.MODELO) AS MODELO,
			MAX(V_EST_NF_ENT.PERC_ALIQ_PIS) AS PERC_ALIQ_PIS,
			MAX(V_EST_NF_ENT.PERC_ALIQ_COFINS) AS PERC_ALIQ_COFINS,
			--   V_EST_NF_ENT.VLR_BASE_PIS,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_PIS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_BASE_PIS,
			--   V_EST_NF_ENT.VLR_BASE_COFINS,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_COFINS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_BASE_COFINS,
			--   V_EST_NF_ENT.VLR_PIS,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_PIS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_PIS,
			--   V_EST_NF_ENT.VLR_COFINS,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_COFINS) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_COFINS,
			MAX(V_EST_NF_ENT.PERC_REDU_BASE_SUBS_IT) AS PERC_REDU_BASE_SUBS_IT ,
			MAX(V_EST_NF_ENT.PERC_REDU_BASE_ICMS_IT) AS PERC_REDU_BASE_ICMS_IT,
			MAX(V_EST_NF_ENT.CST_PIS) AS CST_PIS,
			MAX(V_EST_NF_ENT.ORIGEM_PRODUTO) AS ORIGEM_PRODUTO,
			--   V_EST_NF_ENT.VLR_ICMS_SUBS_DARE,
			ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_SUBS_DARE) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_ICMS_SUBS_DARE,
			COALESCE(max(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD),max(V_EST_NF_ENT.QT_IT)) * max(CASE WHEN ISNULL(MERC.VLR_FABRICA, 0) > 0 THEN 
					ISNULL(MERC.VLR_FABRICA, 0)
				ELSE 
					ISNULL(V_EST_PROD_PRECO_TBL.VLR_FORN, 0)
			END) AS VLR_FABRICA,			
------------------------------------------------------------------------------------------------------			
		/*  sum(V_EST_NF_ENT.QT_IT * CASE WHEN ISNULL(MERC.VLR_FABRICA, 0) > 0
									 THEN ISNULL(MERC.VLR_FABRICA, 0)
									 ELSE ISNULL(V_EST_PROD_PRECO_TBL.VLR_FORN, 0)
								 END) AS VLR_FABRICA
---------------------------------------------------------------------------------------------------------
			*/
			--ISNULL(MAX(V_EST_PROD_PRECO_TBL.VLR_FORN), 0) AS VLR_SHELIN,
			ROUND(AVG((CONVERT(DECIMAL(38,10), ISNULL(V_EST_PROD_PRECO_TBL.VLR_FORN,0)) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),2) AS VLR_SHELIN,
			--ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0) AS VLR_ICMS_DESONERADO,
			ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_ICMS_DESONERADO) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_ICMS_DESONERADO,
			MAX(MERC.DS_MC) AS DS_MC,
			ISNULL(MAX(MERC.NR_CEST), '') NR_CEST,
			LEFT(ISNULL(MAX(V_EST_NF_ENT.OBS1),''),50) AS OBS1,	
			CASE WHEN LEN(MAX(V_EST_NF_ENT.OBS1)) > 50 THEN LEFT(RIGHT(MAX(V_EST_NF_ENT.OBS1),LEN(MAX(V_EST_NF_ENT.OBS1)) - 50),50) ELSE '' END AS OBS2,
			CASE WHEN LEN(MAX(V_EST_NF_ENT.OBS1)) > 100 THEN RIGHT(MAX(V_EST_NF_ENT.OBS1),LEN(MAX(V_EST_NF_ENT.OBS1)) - 100) ELSE '' END AS OBS3,
			LEFT(ISNULL(MAX(V_EST_NF_ENT.OBS2),''),50) AS OBS4,
			CASE WHEN LEN(MAX(V_EST_NF_ENT.OBS2)) > 50 THEN LEFT(RIGHT(MAX(V_EST_NF_ENT.OBS2),LEN(MAX(V_EST_NF_ENT.OBS2)) - 50),50) ELSE '' END AS OBS5,
			LEFT(ISNULL(MAX(V_EST_NF_ENT.OBS4),''),50) AS OBS6,
			LEFT(ISNULL(MAX(V_EST_NF_ENT.OBS5),''),50) AS OBS7,
			--VLR_BASE_FECOP_ST_IT,
			ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_BASE_FECOP_ST_IT,
			MAX(V_EST_NF_ENT.PERC_FECOP_ST) AS PERC_FECOP_ST,
			ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_FECOP_ST_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_FECOP_ST_IT,
			ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_BASE_FECOP_RET_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_BASE_FECOP_RET_IT,
			MAX(V_EST_NF_ENT.PERC_FECOP_RET) AS PERC_FECOP_RET,
			--V_EST_NF_ENT.VLR_FECOP_RET_IT,
			ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_FECOP_RET_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_FECOP_RET_IT,
			MAX(EST_PED_VD.OBS) AS OBS,
			MAX(V_EST_NF_ENT.VLR_FECOP) AS VLR_FECOP,
			--V_EST_NF_ENT.VLR_PMC_DAR_IT,
			ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_PMC_DAR_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_PMC_DAR_IT,
			--V_EST_NF_ENT.VLR_PMPF_DAR_IT,
			ISNULL(ROUND(AVG((CONVERT(DECIMAL(38,10), V_EST_NF_ENT.VLR_PMPF_DAR_IT) / CONVERT(DECIMAL(38,10),V_EST_NF_ENT.QT_IT)) * COALESCE(EST_NF_ENT_IT_EST_PROD_CPL_LOTE.QTDE_PROD,V_EST_NF_ENT.QT_IT)),9),0) AS VLR_PMPF_DAR_IT,			 
			CASE
				WHEN MAX(V_EST_NF_ENT.TP_SUBS_DAR_IT) = 0
				THEN '0 - MVA'
				WHEN MAX(V_EST_NF_ENT.TP_SUBS_DAR_IT) = 1
				THEN '1 - PAUTA'
				WHEN MAX(V_EST_NF_ENT.TP_SUBS_DAR_IT) = 2
				THEN '2 - CARGA TRIB'
				WHEN MAX(V_EST_NF_ENT.TP_SUBS_DAR_IT) = 3
				THEN '3 - PREÇO PMC'
				WHEN MAX(V_EST_NF_ENT.TP_SUBS_DAR_IT) = 4
				THEN '4 - PREÇO PMPF'
				ELSE ''
			END AS TP_SUBS_DAR_IT,
			ISNULL(L.NR_LOTE,'') AS NR_LOTE
			,V_EST_NF_ENT.CD_EMP
			,V_EST_NF_ENT.CD_NF
			,ISNULL(V_EST_NF_ENT.CD_BENEF_IT,'') AS CD_BENEF
			,ISNULL(MOTIVO.DESCRICAO,'') AS MOTIVO_DESONERADO_ICMS
			,ISNULL(V_EST_NF_ENT.VLR_ICMS_SUBSTITUTO,0) AS VLR_ICMS_SUBSTITUTO
            FROM 		 
				 V_EST_NF_ENT 
				 join #RsNotaE TP ON
				 V_EST_NF_ENT.CD_EMP	= TP.CD_EMP AND
				 V_EST_NF_ENT.CD_FILIAL = TP.CD_FILIAL AND
				 V_EST_NF_ENT.CD_NF		= TP.CD_NF AND 
				 V_EST_NF_ENT.DT_ENT	= TP.DT_ENT
				 LEFT JOIN EST_NF_ENT_PED_VD ON
				 V_EST_NF_ENT.CD_EMP = EST_NF_ENT_PED_VD.CD_EMP AND
				 V_EST_NF_ENT.CD_FILIAL = EST_NF_ENT_PED_VD.CD_FILIAL AND
				 V_EST_NF_ENT.CD_NF = EST_NF_ENT_PED_VD.CD_NF
				 LEFT JOIN EST_PED_VD ON
				 EST_NF_ENT_PED_VD.CD_EMP = EST_PED_VD.CD_EMP AND
				 EST_NF_ENT_PED_VD.CD_FILIAL = EST_PED_VD.CD_FILIAL AND
				 EST_NF_ENT_PED_VD.CD_PED = EST_PED_VD.CD_PED
				 INNER JOIN #TMPMOV ON 
				 V_EST_NF_ENT.CD_MOV_OP = #TMPMOV.CD_MOV_OP
				 inner join #TmpFilial fl on 
				 V_EST_NF_ENT.CD_FILIAL = fl.CD_FILIAL  
				 INNER JOIN EST_PROD_CPL C ON 
				 V_EST_NF_ENT.CD_EMP	= C.CD_EMP AND 
				 V_EST_NF_ENT.CD_PROD	= C.CD_PROD AND 
				 V_EST_NF_ENT.CD_FILIAL	= C.CD_FILIAL
				 INNER JOIN #EST_PROD_ARV_MERC MERC ON 
				 C.CD_EMP = MERC.CD_EMP AND 
				 C.CD_PROD = MERC.CD_PROD   
				 LEFT OUTER JOIN EST_NF_ENT_CANCEL ON 
				 V_EST_NF_ENT.CD_EMP = EST_NF_ENT_CANCEL.CD_EMP
				 AND V_EST_NF_ENT.CD_FILIAL = EST_NF_ENT_CANCEL.CD_FILIAL
				 AND V_EST_NF_ENT.CD_NF = EST_NF_ENT_CANCEL.CD_NF
				 LEFT OUTER JOIN V_EST_PROD_PRECO_TBL ON 
				 V_EST_NF_ENT.CD_EMP = V_EST_PROD_PRECO_TBL.CD_EMP
				 AND V_EST_NF_ENT.CD_FILIAL = V_EST_PROD_PRECO_TBL.CD_FILIAL
				 AND V_EST_NF_ENT.CD_PROD = V_EST_PROD_PRECO_TBL.CD_PROD
				 LEFT JOIN #TMPRESULT2 SC ON 
				 V_EST_NF_ENT.CD_EMP = SC.CD_EMP
				 AND V_EST_NF_ENT.CD_FILIAL = SC.CD_FILIAL
				 AND V_EST_NF_ENT.CD_NF = SC.CD_NF
				 AND V_EST_NF_ENT.CD_PROD = SC.CD_PROD
				 LEFT OUTER JOIN #RsNotaFiscalDuplicata CRED ON 
				 V_EST_NF_ENT.CD_EMP = CRED.CD_EMP AND
				 V_EST_NF_ENT.CD_FILIAL = CRED.CD_FILIAL AND
				 V_EST_NF_ENT.CD_NF = CRED.CD_NF
				---ADD DAQUI PARA BAIXO PARA PEGAR O LOTE ----------
				INNER JOIN EST_NF_ENT_IT I ON
				V_EST_NF_ENT.CD_EMP=I.CD_EMP AND
				V_EST_NF_ENT.CD_FILIAL=I.CD_FILIAL AND
				V_EST_NF_ENT.CD_NF=I.CD_NF AND
				V_EST_NF_ENT.CD_PROD=I.CD_PROD
				LEFT OUTER JOIN EST_NF_ENT_IT_EST_PROD_CPL_LOTE ON
				I.CD_EMP=EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_EMP AND
				I.CD_FILIAL=EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_FILIAL AND
				I.CD_NF=EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_NF AND 
				I.CD_PROD=EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_PROD
				LEFT OUTER JOIN EST_PROD_CPL_LOTE L ON
				L.CD_EMP=V_EST_NF_ENT.CD_EMP AND
				L.CD_FILIAL=V_EST_NF_ENT.CD_FILIAL AND
				L.CD_PROD=I.CD_PROD AND 
				L.CD_LOTE=EST_NF_ENT_IT_EST_PROD_CPL_LOTE.CD_LOTE
			-----------FIM PEGA LOTE ------------
			OUTER APPLY (SELECT TOP 1 MOTIVO.DESCRICAO FROM TBL_ICMS_DESONERADO_MOTIVO MOTIVO WHERE V_EST_NF_ENT.ICMS_DESONERADO_MOTIVO = MOTIVO.CD_MOTIVO) MOTIVO
		  WHERE 
			 V_EST_NF_ENT.CD_EMP =@CD_EMP
			 AND   V_EST_NF_ENT.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM 
			 AND EST_NF_ENT_CANCEL.CD_NF IS NULL 
			 AND V_EST_NF_ENT.CD_FORN_FILIAL = CASE  WHEN @GRP = 1  THEN 0
										  WHEN @GRP = 0 THEN  V_EST_NF_ENT.CD_FORN_FILIAL
										  END 
			 AND V_EST_NF_ENT.QT_IT <> 0
		GROUP BY V_EST_NF_ENT.CD_PROD ,L.NR_LOTE ,V_EST_NF_ENT.CD_EMP,V_EST_NF_ENT.CD_NF ,V_EST_NF_ENT.CD_BENEF_IT
			,MOTIVO.DESCRICAO, V_EST_NF_ENT.VLR_ICMS_SUBSTITUTO
		ORDER BY V_EST_NF_ENT.CD_PROD;	
	END
	ELSE
	BEGIN
		INSERT INTO #TMPRESULT

            SELECT 
                   V_EST_NF_ENT.DT_ENT,
                   CASE
				    WHEN V_EST_NF_ENT.STS_NF = 0
				    THEN 'NORMAL'
				    ELSE 'CANCELADA'
                   END STS_NF,
                   V_EST_NF_ENT.SERIE,
                   V_EST_NF_ENT.CD_ORIG,
                   V_EST_NF_ENT.DT_EMI_NF,
                   V_EST_NF_ENT.NR_NF,
                   V_EST_NF_ENT.CD_FILIAL,
                   V_EST_NF_ENT.CD_PROD,				   
                   MERC.DS_PROD,
				   COALESCE((SELECT TOP 1 CD_BARRA FROM EST_PROD_CD_BARRA WHERE CD_EMP = MERC.CD_EMP AND CD_PROD = MERC.CD_PROD AND COALESCE(EAN_CAIXA_FECHADA,0) = 0 AND COALESCE(NAO_ENVIA_WMS,0) = 0 AND COALESCE(FLAG_PRE_VENCIDOS,0) = 0 ORDER BY DT_CAD DESC),'') AS CD_BARRA,
                   V_EST_NF_ENT.QT_IT AS QT_IT,
				   0 AS QT_IT_LOTE,
                   (V_EST_NF_ENT.VLR_IT * V_EST_NF_ENT.QT_IT) AS VLR_IT_TOTAL_BRUTO,
                   CONVERT(FLOAT,V_EST_NF_ENT.VLR_TOT_IT)/CONVERT(FLOAT,V_EST_NF_ENT.QT_IT) AS VLR_IT,
                   V_EST_NF_ENT.VLR_DESC_IT AS VLR_DESC,
                  V_EST_NF_ENT.QT_IT * (V_EST_NF_ENT.VLR_IT - (V_EST_NF_ENT.VLR_DESC_IT / CONVERT(FLOAT,V_EST_NF_ENT.QT_IT))) as VLR_TOT_IT,
                   ROUND((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_CUSTO_MD), 2) AS VLR_CUSTO_MD,
                   V_EST_NF_ENT.VLR_BASE_ICMS_IT AS VLR_BASE_ICMS,
                   V_EST_NF_ENT.VLR_ICMS_IT,
                   V_EST_NF_ENT.VLR_BASE_SUBS_IT AS VLR_BASE_SUBS,
                   V_EST_NF_ENT.VLR_ICMS_SUBS_IT AS VLR_ICMS_SUBS,
                   CASE
				   WHEN COALESCE(SC.CD_PROD,0) = 0
                       THEN 0
                       ELSE SC.VLR_ICMS_REC
                   END VLR_ICMS_REAL,
                   V_EST_NF_ENT.VLR_IPI_IT AS VLR_IPI,
                   V_EST_NF_ENT.CD_TRIB_FC,
                   LEFT(V_EST_NF_ENT.CFOP, 5) AS CFOP,
                   V_EST_NF_ENT.DS_MOV_OP_USUAL AS DS_MOV_OP,

                   CASE WHEN C.CD_SIGLA = 4 THEN 'D' 
						WHEN C.CD_SIGLA = 3 THEN 'C' 
						WHEN C.CD_SIGLA = 2 THEN 'B' 
						WHEN C.CD_SIGLA = 1 THEN 'A' 
						WHEN C.CD_SIGLA = 5 THEN 'AA' 
						ELSE 'D' END DS_SIGLA,

                   (V_EST_NF_ENT.VLR_PRC_CUSTO * V_EST_NF_ENT.QT_IT) AS VLR_PRC_CUSTO,

                   CASE WHEN ISNULL(V_EST_NF_ENT.VLR_PMC_DAR_IT, 0 )> 0 THEN V_EST_NF_ENT.VLR_PMC_DAR_IT
						ELSE ISNULL( V_EST_NF_ENT.VLR_PROD_PMC, 0 )
					END			AS VLR_PMC,

					CASE WHEN COALESCE(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0) = 0
						THEN VLR_OUTROS_CABE_RATEIO
						ELSE V_EST_NF_ENT.VLR_OUTRAS_DESPESAS
					END AS VLR_OUTRAS_DESPESAS,
					
                   VLR_FRETE_CABE_RATEIO AS VLR_FRETE,
                   CASE
                       WHEN V_EST_NF_ENT.VLR_OUTROS = 0
                       THEN CASE
                                WHEN V_EST_NF_ENT.VLR_FRETE = 0 THEN 
									(((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT +  V_EST_NF_ENT.VLR_FECOP_ST_IT) + 
									CASE WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1 THEN 
										0
									ELSE 
										V_EST_NF_ENT.VLR_ICMS_RET
									END + ISNULL(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0) - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
																					         ELSE 0 
																				         END
                                ELSE 
									(((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT +  V_EST_NF_ENT.VLR_FECOP_ST_IT + (ROUND((CONVERT( FLOAT, V_EST_NF_ENT.VLR_FRETE) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_FRETE)), 9) * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT + V_EST_NF_ENT.VLR_FECOP_ST_IT))) + 
										CASE WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1 THEN 
											0
										ELSE 
											V_EST_NF_ENT.VLR_ICMS_RET
                                        END + ISNULL(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0) - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
																								 ELSE 0 
																							  END - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
																										 ELSE 0 
																									 END
                            END
                       ELSE 
							CASE WHEN CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_OUTROS) > 0 THEN 
								CASE WHEN V_EST_NF_ENT.VLR_FRETE = 0 THEN 
									(((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT +  V_EST_NF_ENT.VLR_FECOP_ST_IT + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_OUTROS) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_OUTROS)), 9) * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT + V_EST_NF_ENT.VLR_FECOP_ST_IT))) + 
									CASE WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1 THEN 
										0
                                    ELSE 
										V_EST_NF_ENT.VLR_ICMS_RET
									END - CASE WHEN V_EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO = 1  THEN ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
											   ELSE 0 
										   END
                                ELSE 
									(((V_EST_NF_ENT.QT_IT * V_EST_NF_ENT.VLR_IT) - V_EST_NF_ENT.VLR_DESC_IT) + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT +  V_EST_NF_ENT.VLR_FECOP_ST_IT + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_OUTROS) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_OUTROS)), 9) * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT + V_EST_NF_ENT.VLR_FECOP_ST_IT)) + (ROUND((CONVERT(FLOAT, V_EST_NF_ENT.VLR_FRETE) / CONVERT(FLOAT, V_EST_NF_ENT.VLR_NF - V_EST_NF_ENT.VLR_FRETE)), 9) * (V_EST_NF_ENT.VLR_TOT_IT + V_EST_NF_ENT.VLR_IPI_IT + V_EST_NF_ENT.VLR_ICMS_SUBS_IT + V_EST_NF_ENT.VLR_FECOP_ST_IT))) + 
										CASE WHEN FLAG_ICMS_SUBST_PAGO_ANTERIOR = 1 THEN 
											0
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ELSE ROUND(V_EST_NF_ENT.VLR_ICMS_RET, 2)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  END - ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0)
                                     END
                                ELSE 0
                            END
                   END AS VLR_COMPRA,
                   MERC.NM_FABRIC,
                   MERC.DS_ARV_MERC_CATEG,
                   MERC.DS_ARV_MERC_DEPTO,
                   MERC.DS_ARV_MERC_AREA_ATEND,
                   MERC.DS_ARV_MERC_SEG,
                   MERC.DS_ARV_MERC_LINHA,
                   MERC.DS_ARV_MERC_CONSUMO,
                   MERC.DS_ARV_MERC_MIX,
                   MERC.DS_ARV_MERC_PAPEL,
                   MERC.DS_ARV_MERC_FAMILIA,
                   MERC.DS_ARV_MERC_MTZ_BCG,
                   V_EST_NF_ENT.NM_ORIG_FANT,
					CASE
						WHEN V_EST_NF_ENT.TP_MOV = 0
						THEN 'COMPRAS'
						ELSE 'OUTRAS ENTRADAS'
					END TIPO_ENTRADA,
			
                   TIPO_FORNECEDOR,
                   CASE
                       WHEN V_EST_NF_ENT.ATU_EST = 1
                       THEN 'ACRESCENTOU ESTOQUE'
                       ELSE 'NAO ACRESCENTOU ESTOQUE'
                   END AS ATU_EST,
                   ISNULL(CRED.NR_DP, 0) AS NR_DP_PAG,
                   CASE
                       WHEN CRED.CD_NF IS NULL
                       THEN 'NAO'
                       ELSE 'SIM'
                   END AS CONTASPAGAR,
                   CASE
                       WHEN V_EST_NF_ENT.EXPORT_NF_ESCRITA = 0
                       THEN 'SIM'
                       ELSE 'NAO'
                   END AS EXPORT_NF_ESCRITA,
                   CASE
                       WHEN V_EST_NF_ENT.LISTA_PROD = 0
                       THEN '0 - POSITIVA'
                       WHEN V_EST_NF_ENT.LISTA_PROD = 1
                       THEN '1 - NEGATIVA'
                       WHEN V_EST_NF_ENT.LISTA_PROD = 2
                       THEN '2 - NEUTRA'
                       WHEN V_EST_NF_ENT.LISTA_PROD = 3
                       THEN '3 - NAO USA LISTA'
                   END AS LISTA_PROD,
                   CASE
                       WHEN V_EST_NF_ENT.PIS_COFINS = 0
                       THEN 'NAO'
                       WHEN V_EST_NF_ENT.PIS_COFINS = 1
                       THEN 'SIM'
                   END AS PIS_COFINS,
                   V_EST_NF_ENT.NR_NCM,
                   V_EST_NF_ENT.PERC_IVA,
                   V_EST_NF_ENT.ALIQ_ICMS,
                   V_EST_NF_ENT.CGC_CPF CNPJ,
				   V_EST_NF_ENT.UF UF_EMISSOR,
                   V_EST_NF_ENT.UF_DESTINATARIO UF,
				   ROUND(V_EST_NF_ENT.VLR_ICMS_RET, 2) AS VLR_ICMS_RET,
                   V_EST_NF_ENT.VLR_CRED_BASE_SN,
                   V_EST_NF_ENT.VLR_CRED_ICMS_SN,
                   V_EST_NF_ENT.PERC_DESC_FINAN,
                   V_EST_NF_ENT.VLR_DESC_FINAN_PROD,
                   CASE
                       WHEN V_EST_NF_ENT.ISENTO = 1
                       THEN V_EST_NF_ENT.VLR_TOT_IT
                       ELSE 0
                   END AS VLR_ISENTO,
					CASE
						WHEN V_EST_NF_ENT.SUBS_TRIB_ANT = 1
						THEN (V_EST_NF_ENT.VLR_TOT_IT/ V_EST_NF_ENT.QT_IT)
		   
						ELSE CASE
								WHEN(ICMS + SUBS_TRIB + ICMS_RD) > 1
								THEN (V_EST_NF_ENT.VLR_TOT_IT/ V_EST_NF_ENT.QT_IT) - V_EST_NF_ENT.VLR_BASE_ICMS_IT
								ELSE 0
							END
					END + ISNULL(V_EST_NF_ENT.VLR_OUTRAS_DESPESAS, 0) AS VLR_OUTROS,
                   ISNULL(V_EST_NF_ENT.NR_AUTORIZADOR,0) + SPACE(1),
                   V_EST_NF_ENT.MODELO,
                   V_EST_NF_ENT.PERC_ALIQ_PIS,
                   V_EST_NF_ENT.PERC_ALIQ_COFINS,
                   V_EST_NF_ENT.VLR_BASE_PIS,
                   V_EST_NF_ENT.VLR_BASE_COFINS,
                   V_EST_NF_ENT.VLR_PIS,
                   V_EST_NF_ENT.VLR_COFINS,
                   V_EST_NF_ENT.PERC_REDU_BASE_SUBS_IT,
                   V_EST_NF_ENT.PERC_REDU_BASE_ICMS_IT,
                   V_EST_NF_ENT.CST_PIS,
                   V_EST_NF_ENT.ORIGEM_PRODUTO,
                   V_EST_NF_ENT.VLR_ICMS_SUBS_DARE,
                   (V_EST_NF_ENT.QT_IT * CASE
                                             WHEN ISNULL(MERC.VLR_FABRICA, 0) > 0
                                             THEN ISNULL(MERC.VLR_FABRICA, 0)
                                             ELSE ISNULL(V_EST_PROD_PRECO_TBL.VLR_FORN, 0)
                                         END) AS VLR_FABRICA,
				ISNULL(V_EST_PROD_PRECO_TBL.VLR_FORN, 0) AS VLR_SHELIN,
				ISNULL(V_EST_NF_ENT.VLR_ICMS_DESONERADO, 0) AS VLR_ICMS_DESONERADO,
				MERC.DS_MC,
				ISNULL(MERC.NR_CEST, '') NR_CEST,
				left(ISNULL(V_EST_NF_ENT.OBS1,''),50) AS OBS1,			
				CASE WHEN LEN(V_EST_NF_ENT.OBS1) > 50 THEN LEFT(RIGHT(V_EST_NF_ENT.OBS1,LEN(V_EST_NF_ENT.OBS1) - 50),50) ELSE '' END AS OBS2,
				CASE WHEN LEN(V_EST_NF_ENT.OBS1) > 100 THEN RIGHT(V_EST_NF_ENT.OBS1,LEN(V_EST_NF_ENT.OBS1) - 100) ELSE '' END AS OBS3,
				left(ISNULL(V_EST_NF_ENT.OBS2,''),50) AS OBS4,
				CASE WHEN LEN(V_EST_NF_ENT.OBS2) > 50 THEN LEFT(RIGHT(V_EST_NF_ENT.OBS2,LEN(V_EST_NF_ENT.OBS2) - 50),50) ELSE '' END AS OBS5,
				left(ISNULL(V_EST_NF_ENT.OBS4,''),50) AS OBS6,
				left(ISNULL(V_EST_NF_ENT.OBS5,''),50) AS OBS7,
				VLR_BASE_FECOP_ST_IT,
				--PERC_FECOP_ST,
				V_EST_NF_ENT.PERC_FECOP_ST,
				VLR_FECOP_ST_IT,
				VLR_BASE_FECOP_RET_IT,
				--PERC_FECOP_RET,
				V_EST_NF_ENT.PERC_FECOP_RET,
				VLR_FECOP_RET_IT,
				EST_PED_VD.OBS,
				V_EST_NF_ENT.VLR_FECOP,
                V_EST_NF_ENT.VLR_PMC_DAR_IT,
			    V_EST_NF_ENT.VLR_PMPF_DAR_IT,
			    CASE
                WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 0
                THEN '0 - MVA'
                WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 1
                THEN '1 - PAUTA'
                WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 2
                THEN '2 - CARGA TRIB'
                WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 3
                THEN '3 - PREÇO PMC'
				WHEN V_EST_NF_ENT.TP_SUBS_DAR_IT = 4
                THEN '4 - PREÇO PMPF'
				ELSE ''
				END AS TP_SUBS_DAR_IT
				,'' AS NR_LOTE
				,V_EST_NF_ENT.CD_EMP
				,V_EST_NF_ENT.CD_NF
				,ISNULL(V_EST_NF_ENT.CD_BENEF_IT,'') AS CD_BENEF
				,ISNULL(MOTIVO.DESCRICAO,'') AS MOTIVO_DESONERADO_ICMS
				,ISNULL(V_EST_NF_ENT.VLR_ICMS_SUBSTITUTO,0) AS VLR_ICMS_SUBSTITUTO
			FROM 		 
				 V_EST_NF_ENT 

				 join #RsNotaE TP ON
				 V_EST_NF_ENT.CD_EMP	= TP.CD_EMP AND
				 V_EST_NF_ENT.CD_FILIAL = TP.CD_FILIAL AND
				 V_EST_NF_ENT.CD_NF		= TP.CD_NF AND 
				 V_EST_NF_ENT.DT_ENT	= TP.DT_ENT
							
				 LEFT JOIN EST_NF_ENT_PED_VD ON
				 V_EST_NF_ENT.CD_EMP = EST_NF_ENT_PED_VD.CD_EMP AND
				 V_EST_NF_ENT.CD_FILIAL = EST_NF_ENT_PED_VD.CD_FILIAL AND
				 V_EST_NF_ENT.CD_NF = EST_NF_ENT_PED_VD.CD_NF
					 
				 LEFT JOIN EST_PED_VD ON
				 EST_NF_ENT_PED_VD.CD_EMP = EST_PED_VD.CD_EMP AND
				 EST_NF_ENT_PED_VD.CD_FILIAL = EST_PED_VD.CD_FILIAL AND
				 EST_NF_ENT_PED_VD.CD_PED = EST_PED_VD.CD_PED
				  
				 INNER JOIN #TMPMOV ON 
				 V_EST_NF_ENT.CD_MOV_OP = #TMPMOV.CD_MOV_OP

				 inner join #TmpFilial fl on 
				 V_EST_NF_ENT.CD_FILIAL = fl.CD_FILIAL  
		 
				 INNER JOIN EST_PROD_CPL C ON 
				 V_EST_NF_ENT.CD_EMP	= C.CD_EMP AND 
				 V_EST_NF_ENT.CD_PROD	= C.CD_PROD AND 
				 V_EST_NF_ENT.CD_FILIAL	= C.CD_FILIAL
				   
				 INNER JOIN #EST_PROD_ARV_MERC MERC ON 
				 C.CD_EMP = MERC.CD_EMP AND 
				 C.CD_PROD = MERC.CD_PROD   
		
				 LEFT OUTER JOIN EST_NF_ENT_CANCEL ON 
				 V_EST_NF_ENT.CD_EMP = EST_NF_ENT_CANCEL.CD_EMP
				 AND V_EST_NF_ENT.CD_FILIAL = EST_NF_ENT_CANCEL.CD_FILIAL
				 AND V_EST_NF_ENT.CD_NF = EST_NF_ENT_CANCEL.CD_NF
								
				 LEFT OUTER JOIN V_EST_PROD_PRECO_TBL ON 
				 V_EST_NF_ENT.CD_EMP = V_EST_PROD_PRECO_TBL.CD_EMP
				 AND V_EST_NF_ENT.CD_FILIAL = V_EST_PROD_PRECO_TBL.CD_FILIAL
				 AND V_EST_NF_ENT.CD_PROD = V_EST_PROD_PRECO_TBL.CD_PROD

				 LEFT JOIN #TMPRESULT2 SC ON 
				 V_EST_NF_ENT.CD_EMP = SC.CD_EMP
				 AND V_EST_NF_ENT.CD_FILIAL = SC.CD_FILIAL
				 AND V_EST_NF_ENT.CD_NF = SC.CD_NF
				 AND V_EST_NF_ENT.CD_PROD = SC.CD_PROD

				 LEFT OUTER JOIN #RsNotaFiscalDuplicata CRED ON 
				 V_EST_NF_ENT.CD_EMP = CRED.CD_EMP AND
				 V_EST_NF_ENT.CD_FILIAL = CRED.CD_FILIAL AND
				 V_EST_NF_ENT.CD_NF = CRED.CD_NF
				 OUTER APPLY (SELECT TOP 1 MOTIVO.DESCRICAO FROM TBL_ICMS_DESONERADO_MOTIVO MOTIVO WHERE V_EST_NF_ENT.ICMS_DESONERADO_MOTIVO = MOTIVO.CD_MOTIVO) MOTIVO
		  WHERE 
			 V_EST_NF_ENT.CD_EMP =@CD_EMP
			 AND   V_EST_NF_ENT.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM 
			 AND EST_NF_ENT_CANCEL.CD_NF IS NULL 
			 AND V_EST_NF_ENT.CD_FORN_FILIAL = CASE  WHEN @GRP = 1  THEN 0
										  WHEN @GRP = 0 THEN  V_EST_NF_ENT.CD_FORN_FILIAL
										  END 
 
			 AND V_EST_NF_ENT.QT_IT <>0;
	END
 /*********************************************************************************************************************************/	
		PRINT 'INSERT 24 '+CONVERT(VARCHAR, GETDATE(), 108);
		INSERT INTO #TmpResult
		SELECT 
			 V_EST_NF_ENT_CPL.DT_ENT,
			 CASE
			 WHEN V_EST_NF_ENT_CPL.STS_NF = 0
			 THEN 'NORMAL'
			 ELSE 'CANCELADA'
			 END STS_NF,
			 V_EST_NF_ENT_CPL.SERIE,
			 V_EST_NF_ENT_CPL.CD_ORIG,
			 V_EST_NF_ENT_CPL.DT_EMI_NF,
			 V_EST_NF_ENT_CPL.NR_NF,
			 V_EST_NF_ENT_CPL.CD_FILIAL,
			 0 AS CD_PROD,
			 'NOTA FISCAL SOMENTE CABECALHO' AS DS_PROD,
			 '' AS CD_BARRA,
			 0 AS QT_IT,
			 0 AS QT_IT_LOTE,
			 V_EST_NF_ENT_CPL.VLR_TOT_PROD AS VLR_IT_TOTAL_BRUTO,
			 0 AS VLR_IT,
			 0 AS VLR_DESC,
			 0 AS VLR_TOT_IT,
			 0 AS VLR_CUSTO_MD,
			 V_EST_NF_ENT_CPL.VLR_BASE_ICMS,
			 V_EST_NF_ENT_CPL.VLR_ICMS,
			 V_EST_NF_ENT_CPL.VLR_BASE_ICMS_SUBS,
			 V_EST_NF_ENT_CPL.VLR_ICMS_SUBS,
			 CASE
			 WHEN V_EST_NF_ENT_CPL.VLR_ICMS_SUBS = 0
			 THEN V_EST_NF_ENT_CPL.VLR_ICMS
			 ELSE 0
			 END VLR_ICMS_REAL,
			 V_EST_NF_ENT_CPL.VLR_IPI,
			 '000' AS CD_TRIB_FC,
			 LEFT(CFOP, 5) AS CFOP,
			 DS_MOV_OP,
			 'D' AS DS_SIGLA,
			 V_EST_NF_ENT_CPL.VLR_NF AS VLR_PRC_CUSTO,
			 0 VLR_PMC,
			 0 AS VLR_OUTRAS_DESPESAS,
			 0 AS VLR_FRETE,
			 V_EST_NF_ENT_CPL.VLR_NF AS VLR_COMPRA,
			 'NAO DEFINIDO' AS NM_FABRIC,
			 'NAO DEFINIDO' AS DS_ARV_MERC_CATEG,
			 'NAO DEFINIDO' AS DS_ARV_MERC_DEPTO,
			 'NAO DEFINIDO' AS DS_ARV_MERC_AREA_ATEND,
			 'NAO DEFINIDO' AS DS_ARV_MERC_SEG,
			 'NAO DEFINIDO' AS DS_ARV_MERC_LINHA,
			 'NAO DEFINIDO' AS DS_ARV_MERC_CONSUMO,
			 'NAO DEFINIDO' AS DS_ARV_MERC_MIX,
			 'NAO DEFINIDO' AS DS_ARV_MERC_PAPEL,
			 'NAO DEFINIDO' AS DS_ARV_MERC_FAMILIA,
			 'NAO DEFINIDO' AS DS_ARV_MERC_MTZ_BCG,
			 NM_ORIG_FANT,
			 'NOTAS FISCAIS SOMENTE CABECALHO' AS TIPO_ENTRADA,
			 TIPO_FORNECEDOR,
			 'NAO ACRESCENTOU ESTOQUE' AS ATU_EST,
			 ISNULL(PG_CRED_EST_NF_ENT.NR_DP, 0) AS NR_DP_PAG,
			 CASE
			 WHEN PG_CRED_EST_NF_ENT.CD_NF IS NULL
			 THEN 'NAO'
			 ELSE 'SIM'
			 END AS CONTASPAGAR,
			 CASE
			 WHEN V_EST_NF_ENT_CPL.EXPORT_NF_ESCRITA = 0
			 THEN 'SIM'
			 ELSE 'NAO'
			 END AS EXPORT_NF_ESCRITA,
			 'NAO DEFINIDO' AS LISTA_PROD,
			 'NAO' AS PIS_COFINS,
			 '' AS NR_NCM,
			 0 AS PERC_IVA,
			 0 AS ALIQ_ICMS,
			 V_EST_NF_ENT_CPL.CGC_CPF CNPJ,
			 V_EST_NF_ENT_CPL.UF UF_EMISSOR,
			 V_EST_NF_ENT_CPL.UF_DESTINATARIO,
			 0 AS VLR_ICMS_RET,
			 0 AS VLR_CRED_BASE_SN,
			 0 AS VLR_CRED_ICMS_SN,
			 0 AS PERC_DESC_FINAN,
			 0 AS VLR_DESC_FINAN_PROD,
			 0 AS VLR_ISENTO,
			 0 AS VLR_OUTROS,
			 ISNULL(V_EST_NF_ENT_CPL.NR_AUTORIZADOR,0) + SPACE(1),
			 V_EST_NF_ENT_CPL.MODELO,
			 0 AS PERC_ALIQ_PIS,
			 0 AS PERC_ALIQ_COFINS,
			 0 AS VLR_BASE_PIS,
			 0 AS VLR_BASE_COFINS,
			 0 AS VLR_PIS,
			 0 AS VLR_COFINS,
			 0 AS PERC_REDU_BASE_SUBS_IT,
			 0 AS PERC_REDU_BASE_ICMS_IT,
			 0 AS CST_PIS,
			 0 AS ORIGEM_PRODUTO,
			 0 AS VLR_ICMS_SUBS_DARE,
			 0 AS VLR_FABRICA,
			 0 AS VLR_SHELIN,
			 0 AS VLR_ICMS_DESONERADO,
			 '' AS DS_MC,
			 '' AS NR_CEST,
			 '' AS OBS1,
			 '' AS OBS2,
			 '' AS OBS3,
			 '' AS OBS4,
			 '' AS OBS5,
			 '' AS OBS6,
			 '' AS OBS7,
			 0 AS VLR_BASE_FECOP_ST_IT,
			 0 AS PERC_FECOP_ST,
			 0 AS VLR_FECOP_ST_IT,
			 0 AS VLR_BASE_FECOP_RET_IT,
			 0 AS PERC_FECOP_RET,
			 0 AS VLR_FECOP_RET_IT,
			EST_PED_VD.OBS,
			0 AS VLR_FECOP,
			0 AS VLR_PMC_DAR_IT,
			0 AS VLR_PMPF_DAR_IT,
			'' AS TP_SUBS_DAR_IT,
			'' AS NR_LOTE,
			V_EST_NF_ENT_CPL.CD_EMP,
			V_EST_NF_ENT_CPL.CD_NF,
			'' AS CD_BENEF,
			'' AS MOTIVO_DESONERADO_ICMS,
			0 AS VLR_ICMS_SUBSTITUTO
		FROM 
			V_EST_NF_ENT_CPL
			LEFT JOIN EST_NF_ENT_PED_VD ON
			V_EST_NF_ENT_CPL.CD_EMP = EST_NF_ENT_PED_VD.CD_EMP AND
			V_EST_NF_ENT_CPL.CD_FILIAL = EST_NF_ENT_PED_VD.CD_FILIAL AND
			V_EST_NF_ENT_CPL.CD_NF = EST_NF_ENT_PED_VD.CD_NF
			LEFT JOIN EST_PED_VD ON
			EST_NF_ENT_PED_VD.CD_EMP = EST_PED_VD.CD_EMP AND
			EST_NF_ENT_PED_VD.CD_FILIAL = EST_PED_VD.CD_FILIAL AND
			EST_NF_ENT_PED_VD.CD_PED = EST_PED_VD.CD_PED
			inner join #TmpFilial fl on 
			V_EST_NF_ENT_CPL.CD_FILIAL = fl.CD_FILIAL 
			LEFT OUTER JOIN PG_CRED_EST_NF_ENT ON 
			V_EST_NF_ENT_CPL.CD_EMP = PG_CRED_EST_NF_ENT.CD_EMP AND 
			V_EST_NF_ENT_CPL.CD_FILIAL = PG_CRED_EST_NF_ENT.CD_FILIAL AND 
			V_EST_NF_ENT_CPL.CD_NF = PG_CRED_EST_NF_ENT.CD_NF
			LEFT OUTER JOIN #RsNotaFiscalDuplicata CRED ON 
			V_EST_NF_ENT_CPL.CD_EMP = CRED.CD_EMP AND
			V_EST_NF_ENT_CPL.CD_FILIAL = CRED.CD_FILIAL AND
			V_EST_NF_ENT_CPL.CD_NF = CRED.CD_NF	
		WHERE 
			V_EST_NF_ENT_CPL.CD_EMP = 1 
			AND V_EST_NF_ENT_CPL.DT_EMI_NF between @DT_INI AND @DT_FIM
			AND V_EST_NF_ENT_CPL.STS_NF = 0;
	end
    DROP TABLE #RsNotaFiscalDuplicata;	 
     /*********************************************************************************************************************************/
     /**************************************************Final Result*******************************************************************/
     /*********************************************************************************************************************************/
	IF @VINCULO_SAI_NF_ENT = 0
	BEGIN
			SELECT *
			FROM #TMPRESULT;
	end
	ELSE
	begin
		    SELECT T.*
			FROM #TMPRESULT T
			WHERE NOT EXISTS
				(SELECT 1
				 FROM EST_NF_SAI_NF_ENT ES
				 WHERE T.CD_EMP = ES.CD_EMP
				   AND T.CD_FILIAL = ES.CD_FILIAL
				   AND T.CD_NF_ENT = ES.CD_NF_ENT)
			  AND NOT EXISTS
				(SELECT 1
				 FROM PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT B
				 WHERE T.CD_EMP = B.CD_EMP
				   AND T.CD_FILIAL = B.CD_FILIAL
				   AND T.CD_NF_ENT = B.CD_NF)
	END 
     /*********************************************************************************************************************************/
PRINT 'P_EST_PROD_CPL_ENTRADAS FINALIZADA!'+CONVERT(VARCHAR, GETDATE(), 108);

GO


